/* eslint-disable camelcase */

import {
    OrderCancellationDetailsFieldType,
    OrderCancellationDetailsReasonType,
} from 'server/api/HotelsBookAPI/constants/orderCancellationDetails';
import {EFiscalReceiptType} from 'projects/hotels/constants/EFiscalReceiptType';

import EOriginalPaymentErrorCode from 'types/common/EOriginalPaymentErrorCode';
import {IPromoCampaigns} from 'types/hotels/book/IPromoCampaigns';
import {TInstantDateTimeType} from 'types/common/date/IDate';
import {IAppliedPromoCampaigns} from 'types/hotels/offer/IHotelOffer';
import EDisplayOrderState from 'types/common/orders/EDisplayOrderState';
import {EPromoCodesApplicationType} from 'types/hotels/book/IApplyPromoCodes';

import ValueType from 'utilities/currency/ValueType';
import {CurrencyType} from 'utilities/currency/CurrencyType';
import IPrice from 'utilities/currency/PriceInterface';

import {EHotelOrderPaymentType, IHotelGuest, TOrderIdType} from './IOrder';
import {
    IBookOfferCancellationInfoResponse,
    IBookOfferResponse,
} from './IBookOfferResponse';

export interface IOrderPriceResponse {
    amount: ValueType;
    currency: CurrencyType;
}

export interface IOrderErrorPaymentResponse {
    code: EOriginalPaymentErrorCode;
    amount: IPrice;
}

export interface IOrderCurrentPaymentResponse {
    amount: IPrice;
    paymentUrl: string;
    type: EHotelOrderPaymentType;
}

export interface IOrderNextPaymentResponse {
    amount: IPrice;
    penaltyIfUnpaid: IPrice;
    paymentEndsAt: TInstantDateTimeType;
}

export interface IOrderPaymentResponse {
    errorInfo?: EOriginalPaymentErrorCode;
    paymentUrl?: string;
    receipts?: {
        type: EFiscalReceiptType;
        url: string;
    }[];
    current?: IOrderCurrentPaymentResponse;
    next?: IOrderNextPaymentResponse;
    error?: IOrderErrorPaymentResponse;
    amountPaid?: IPrice;
    mayBeStarted?: boolean;
    mayBeCancelled?: boolean;
    usesDeferredPayments?: boolean;
    usesZeroFirstPayment?: boolean;
}

export interface IOrderGuestsInfoResponse {
    customerEmail: string;
    customerPhone: string;
    guests: IHotelGuest[];
}

export interface IOrderRefundInfoResponse {
    penalty: IOrderPriceResponse;
    refund: IOrderPriceResponse;
    penaltyIntervalIndex: number;
    refundDateTime: string;
}

export interface IOrderConfirmationInfoResponse {
    confirmationId: string;
}

// Дочерний объект заказа: order_cancellation_details, описывающий причины отмены для CANCELLED заказов
// https://st.yandex-team.ru/HOTELS-4653
export interface IOrderCancellationDetailsResponse {
    reason?: OrderCancellationDetailsReasonType;
    invalidInputDetails?: {
        fieldType: OrderCancellationDetailsFieldType;
    }[];
}

export interface IOrderResponse {
    id: TOrderIdType;
    yandexOrderId: string;
    orderInfo: IBookOfferResponse;
    guestInfo: IOrderGuestsInfoResponse;
    status: EHotelOrderStatus;
    displayState: EDisplayOrderState;
    orderCancellationDetails?: IOrderCancellationDetailsResponse | null;
    payment?: IOrderPaymentResponse;
    confirmationInfo: IOrderConfirmationInfoResponse;
    refundInfo?: IOrderRefundInfoResponse;
    cancellationInfoUnfiltered?: IBookOfferCancellationInfoResponse;
    orderPriceInfo?: IOrderPriceInfoResponse;
    appliedPromoCampaigns?: IAppliedPromoCampaigns;
    tripId?: string | null;
    canGenerateBusinessTripDoc?: boolean;
}

export enum EHotelOrderStatus {
    IN_PROGRESS = 'IN_PROGRESS',
    RESERVED = 'RESERVED',
    RESERVED_WITH_RESTRICTIONS = 'RESERVED_WITH_RESTRICTIONS',
    AWAITS_PAYMENT = 'AWAITS_PAYMENT',
    PAYMENT_FAILED = 'PAYMENT_FAILED',
    CONFIRMED = 'CONFIRMED',
    CANCELLED = 'CANCELLED',
    CANCELLED_WITH_REFUND = 'CANCELLED_WITH_REFUND',
    REFUNDED = 'REFUNDED',
    REFUND_FAILED = 'REFUND_FAILED',
    FAILED = 'FAILED',
}

export interface IOrderStatusResponse {
    status: string;
    paymentUrl?: string;
    paymentError: string | null;
}

export interface IOrderPriceInfoResponse {
    price: IPrice;
    originalPrice: IPrice;
    discountAmount: IPrice;
    promoCampaigns: IPromoCampaigns;
    promoCodeApplicationResults: IPromoCodeApplicationResultResponse[];
}

export interface IPromoCodeApplicationResultResponse {
    code: string;
    type: EPromoCodesApplicationType;
    discountAmount?: IPrice;
}
