import EHotelPartnerId from 'server/api/GenericOrderApi/types/common/service/IHotelServiceInfo/IHotelOfferInfo/EHotelPartnerId';

import {IBaseErrorResponse} from 'server/controllers/hotelsApiController/HotelsBaseController';

/* 1. RequestParams */

export interface ITestBookOfferTokenRequestParams {
    originalId?: number;
    partnerId?: EHotelPartnerId;
    occupancy?: string;
    forceAvailability?: boolean;
    checkinDate?: string;
    checkoutDate?: string;
    cancellation?: ECancellation;
    pansionType?: EPansionType;
    offerName?: string;
    priceAmount?: number;
    partiallyRefundRate?: number;
    partiallyRefundableInMinutes?: number;
    nonRefundableInMinutes?: number;
    getOfferOutcome?: EOutcome;
    createOrderOutcome?: EOutcome;
    hotelDataLookupOutcome?: EHotelDataLookupOutcome;
    reservationOutcome?: EReservationOutcome;
    confirmationOutcome?: EConfirmationOutcome;
    refundOutcome?: ERefundOutcome;
    priceMismatchRate?: number;
    existingDolphinOrder?: string;
    ignorePaymentScheduleRestrictions?: boolean;
    discountAmount?: number;
    mealPrice?: number;
    isPostPay?: boolean;
}

export enum EPansionType {
    UNKNOWN = 'PT_UNKNOWN',
    AI = 'PT_AI',
    BB = 'PT_BB',
    FB = 'PT_FB',
    HB = 'PT_HB',
    RO = 'PT_RO',
    UAI = 'PT_UAI',
    LAI = 'PT_LAI',
    BD = 'PT_BD',
}

export enum ECancellation {
    FULLY_REFUNDABLE = 'CR_FULLY_REFUNDABLE',
    PARTIALLY_REFUNDABLE = 'CR_PARTIALLY_REFUNDABLE',
    NON_REFUNDABLE = 'CR_NON_REFUNDABLE',
    CUSTOM = 'CR_CUSTOM',
}

export enum EOutcome {
    SUCCESS = 'OO_SUCCESS',
    SOLD_OUT = 'OO_SOLD_OUT',
    PRICE_MISMATCH = 'OO_PRICE_MISMATCH',
}

export enum EHotelDataLookupOutcome {
    REAL = 'HO_REAL',
    MOCKED = 'HO_MOCKED',
}

export enum EReservationOutcome {
    SUCCESS = 'RO_SUCCESS',
    SOLD_OUT = 'RO_SOLD_OUT',
    PRICE_MISMATCH = 'RO_PRICE_MISMATCH',
}

export enum EConfirmationOutcome {
    SUCCESS = 'CO_SUCCESS',
    NOT_FOUND = 'CO_NOT_FOUND',
    PRICE_MISMATCH = 'CO_PRICE_MISMATCH',
    WAITLIST_ALWAYS = 'CO_WAITLIST_ALWAYS',
    WAITLIST_THEN_OK = 'CO_WAITLIST_THEN_OK',
    WAITLIST_THEN_ANNULATE = 'CO_WAITLIST_THEN_ANNULATE',
}

export enum ERefundOutcome {
    SUCCESS = 'RF_SUCCESS',
    UNEXPECTED_PENALTY = 'RF_UNEXPECTED_PENALTY',
    UNABLE_TO_REFUND = 'RF_UNABLE_TO_REFUND',
}

/* 2. SuccessResponse */

export interface IOfferToken {
    offerName: string;
    pansionType: string;
    hasFreeCancellation: boolean;
    price: number;
    token: string;
    bookingPageUrl: number;
}

export interface ITestBookOfferTokenResponse {
    data: {
        offerTokens: IOfferToken[];
    };
}

/* 3. ErrorResponse */

export interface ITestBookOfferTokenError extends IBaseErrorResponse {}
