/* eslint-disable camelcase */

import {StatusCodes} from '../constants/statusCodes';
import {EOfferStatus} from 'projects/hotels/constants/EOfferStatus';

export enum EStartPaymentCustomerSource {
    MOBILE = 'mobile',
    DESKTOP = 'desktop',
}

export interface IStartPaymentParams {
    orderId: string;
    returnUrl: string;
    customerSource: EStartPaymentCustomerSource;
    paymentTestContextToken?: string;
}

export interface IStartPaymentRequestParams {
    order_id: string;
    return_url: string;
    customer_source: EStartPaymentCustomerSource;

    /** Платежный тестовый контекст */
    payment_test_context_token?: string;
}

export interface IStartPaymentError {
    statusCode: StatusCodes;
    error: {
        code: EOfferStatus;
    };
}

export type TStartPaymentResponse = string;
export type TStartPayment = string;
