import isEmpty from 'lodash/isEmpty';

import {
    IApiAppliedPromoCampaigns,
    ICreateOrderGuest,
} from 'server/api/HotelsBookAPI/types/ICreateOrder';
import {ICustomerCreateOrderRequest} from 'types/hotels/book/ICreateOrder';
import {IBookGuest} from 'types/hotels/book/IBookFormValues';
import {ICreateOrderRequestParams} from '../types/ICreateOrder';
import {IAppliedPromoCampaigns} from 'types/hotels/offer/IHotelOffer';

const prepareGuests = (guests: IBookGuest[]): ICreateOrderGuest[] =>
    guests.map(({firstName, lastName}) => ({
        first_name: firstName || '',
        last_name: lastName || '',
    }));

const preparePromoCampaigns = (
    appliedPromoCampaigns: IAppliedPromoCampaigns | undefined,
): IApiAppliedPromoCampaigns | undefined => {
    const promoCampaigns: IApiAppliedPromoCampaigns = {};

    if (appliedPromoCampaigns?.yandexPlus) {
        promoCampaigns['yandex_plus'] = {
            mode: appliedPromoCampaigns.yandexPlus.mode,
            points: appliedPromoCampaigns.yandexPlus.points,
        };
    }

    if (appliedPromoCampaigns?.whiteLabel) {
        promoCampaigns['white_label'] = {
            customer_number: appliedPromoCampaigns.whiteLabel.customerNumber,
        };
    }

    return isEmpty(promoCampaigns) ? undefined : promoCampaigns;
};

export default (
    payload: ICustomerCreateOrderRequest,
): ICreateOrderRequestParams => {
    const {
        offerOrderInfo: {label, checksum, sessionKey, token},
        formValues: {adult = [], children = [], contacts, priceInfo},
        customerUserAgent,
        customerPassportId,
        customerYandexUid,
        customerLogin,
        customerIp,
        promoCodes,
        paymentTestContextToken,
        appliedPromoCampaigns,
    } = payload;
    const {email, phone} = contacts || {};
    const {bedsGroupId = '0', useDeferredPayments = false} = priceInfo || {};

    return {
        label,
        token,
        checksum,
        customer_email: email || '',
        customer_phone: phone || '',
        guests: prepareGuests([...adult, ...children]),
        selected_bed_group_index: parseInt(bedsGroupId, 10),
        session_key: sessionKey,
        customer_ip: customerIp,
        customer_user_agent: customerUserAgent,
        customer_passport_id: customerPassportId || '',
        customer_login: customerLogin || '',
        customer_yandex_uid: customerYandexUid,
        promo_codes: promoCodes,
        use_deferred_payments: useDeferredPayments,
        payment_test_context_token: paymentTestContextToken,
        applied_promo_campaigns: preparePromoCampaigns(appliedPromoCampaigns),
    };
};
