/* External utilities */
import _get from 'lodash/get';

import {StatusCodes} from '../constants/statusCodes';

import {TCancelOrderType, ICancelOrderError} from '../types/ICancelOrder';

export const prepareCancelOrderResponse = (): TCancelOrderType => {
    return null;
};

export const prepareCancelOrderError = (
    apiError: unknown,
): ICancelOrderError => {
    const responseStatusCode = _get(apiError, 'response.status');

    return {
        statusCode: responseStatusCode || StatusCodes.UNKNOWN_ERROR_STATUS_CODE,
    };
};
