/* External utilities */
import _get from 'lodash/get';

import {StatusCodes} from '../constants/statusCodes';

import {ICheckOrderAuthorizationError} from '../../OrdersAPI/types/ICheckOrderAuthorization';
// todo После мерджа задачи Саши использовать enum для orderType заказов
import {ORDER_TYPE_VALUES} from 'projects/account/lib/orders/types';
import {EAuthorizationOrderType} from 'server/api/OrdersAPI/types/IOrderAuthorization';

export const convertOrderType = (
    orderType: EAuthorizationOrderType,
): string => {
    switch (orderType) {
        case EAuthorizationOrderType.TRAIN: {
            return ORDER_TYPE_VALUES.TRAINS;
        }

        case EAuthorizationOrderType.GENERIC: {
            return ORDER_TYPE_VALUES.TRAINS_GENERIC;
        }

        case EAuthorizationOrderType.HOTEL_EXPEDIA: {
            return ORDER_TYPE_VALUES.HOTELS;
        }

        case EAuthorizationOrderType.AVIA_AEROFLOT: {
            return ORDER_TYPE_VALUES.AVIA;
        }

        default: {
            return orderType;
        }
    }
};

export const prepareCheckOrderAuthorizationError = (
    apiError: any,
): ICheckOrderAuthorizationError => {
    const apiErrorStatus = _get(apiError, 'response.status');
    const apiErrorData = _get(apiError, 'response.data');

    return {
        statusCode: apiErrorStatus || StatusCodes.UNKNOWN_ERROR_STATUS_CODE,
        error: {
            errorData: apiErrorData || null,
        },
    };
};
