/* External utilities */
import _get from 'lodash/get';

import {StatusCodes} from '../constants/statusCodes';

import {ICheckVoucher, ICheckVoucherError} from '../types/ICheckVoucher';
import {IOrderPdfLinkResponse} from '../types/IOrderPdfLinkResponse';

export const prepareCheckVoucher = (
    orderVoucherLink: IOrderPdfLinkResponse,
): ICheckVoucher => {
    const {url} = orderVoucherLink || {};

    return {
        voucherIsReady: Boolean(url),
    };
};

export const prepareCheckVoucherError = (
    apiError: unknown,
): ICheckVoucherError => {
    const apiErrorStatus = _get(apiError, 'response.status');

    return {
        statusCode: apiErrorStatus || StatusCodes.UNKNOWN_ERROR_STATUS_CODE,
        error: {
            errorData: {
                voucherIsReady: false,
            },
        },
    };
};
