import camelcaseKeys from 'camelcase-keys';

import {
    ICreateOrderResponse,
    ICreateOrderErrorResponse,
} from '../types/ICreateOrder';
import {ICreateOrder, ICreateOrderError} from 'types/hotels/book/ICreateOrder';

import {getOfferInfoError} from './prepareOfferInfo';

export const prepareCreateOrderResponse = (
    createOrderResponse: ICreateOrderResponse,
): ICreateOrder => {
    const {id}: ICreateOrderResponse = createOrderResponse || {};

    return {
        orderId: id,
    };
};

export const prepareCreateOrderError = (apiError: any): ICreateOrderError => {
    const {response} = apiError;
    const {status, data}: {status: number; data: ICreateOrderErrorResponse} =
        response || {};

    // @ts-ignore
    const camelCasedData = (
        data ? camelcaseKeys(data, {deep: true}) : {}
    ) as ICreateOrderErrorResponse;

    const {orderInfo} = camelCasedData;

    // TODO which errors can really occur here? Do not use this common method
    // @ts-ignore
    return getOfferInfoError({status, data: orderInfo});
};
