/* External utilities */
import _get from 'lodash/get';

import {StatusCodes} from '../constants/statusCodes';
import {URLs} from 'constants/urls';

/* Types */
import {IDownloadVoucherError} from '../types/IDownloadVoucher';
import {TYandexOrderIdType} from '../types/IOrder';
import {IOrderAuthorizationResponse} from 'server/api/OrdersAPI/types/IOrderAuthorization';

import {hotelsURLs} from 'projects/hotels/utilities/urls';

export const prepareDownloadVoucherError = (
    apiError: unknown,
    retpath: string,
): IDownloadVoucherError => {
    const responseStatus = _get(apiError, 'response.status');
    const responseData = _get(
        apiError,
        'response.data',
    ) as IOrderAuthorizationResponse;

    if (
        responseStatus === StatusCodes.NEED_AUTHORIZATION_STATUS_CODE &&
        responseData
    ) {
        const {id: orderId} = responseData;

        return {
            redirectPath: hotelsURLs.getAuthorizeVoucherPage({
                orderId,
                retpath,
            }),
        };
    }

    return {
        redirectPath: URLs.notFound,
    };
};

export const getDownloadVoucherPdfName = (
    YandexOrderId: TYandexOrderIdType,
): string => `${YandexOrderId}.pdf`;
