/* eslint-disable camelcase */

/* External utilities */
import _get from 'lodash/get';

import {StatusCodes} from '../constants/statusCodes';

import {
    IOrderRefundableInfo,
    IOrderRefundableInfoResponse,
    IOrderRefundableInfoError,
} from '../types/IOrderRefundableInfo';

export const prepareOrderRefundableInfoResponse = (
    responseData: IOrderRefundableInfoResponse,
): IOrderRefundableInfo | null => {
    if (responseData) {
        const {
            penalty: {amount: penaltyAmount, currency: penaltyCurrency},
            refund: {amount: refundAmount, currency: refundCurrency},
            valid_until: validUntil,
            refund_token: refundToken,
        } = responseData;

        return {
            penalty: {
                amount: penaltyAmount,
                currency: penaltyCurrency,
            },
            refund: {
                amount: refundAmount,
                currency: refundCurrency,
            },
            refundToken,
            validUntil,
        };
    }

    return null;
};

export const prepareOrderRefundableInfoError = (
    apiError: any,
): IOrderRefundableInfoError => {
    const responseStatusCode = _get(apiError, 'response.status');

    return {
        statusCode:
            responseStatusCode || StatusCodes.UNKNOWN_ORDER_ERROR_STATUS_CODE,
    };
};
