import {CommonHeaders} from 'server/constants/headers';

import {EApiEntry} from 'types/EApiEntry';
import IGetCrossSaleHotelsRequestParamsV1 from './types/IGetCrossSaleHotelsRequestParamsV1';
import IGetCrossSaleHotelsRequestParamsV3 from './types/IGetCrossSaleHotelsRequestParamsV3';
import IGetCrossSaleHotelsResponseV1 from './types/IGetCrossSaleHotelsResponseV1';
import IGetCrossSaleHotelsResponseV3 from './types/IGetCrossSaleHotelsResponseV3';

import {RestApiClient} from 'server/utilities/RestApiClient';
import {IRequestConfig} from 'server/utilities/HttpClient/IHttpClient';

import {IDependencies} from '../../getContainerConfig';

export class HotelsCrossSaleApi extends RestApiClient {
    private readonly serviceTicket: string;

    constructor({
        logger,
        requestId,
        getApiHost,
        httpClient,
        sendClickHouseStats,
        getServiceTicket,
        rootSpan,
    }: IDependencies) {
        super({
            baseURL: `${getApiHost(EApiEntry.TRAVEL)}/hotels_portal`,
            logger,
            requestId,
            httpClient,
            sendClickHouseStats,
            rootSpan,
        });

        this.serviceTicket = getServiceTicket('travelAPI');
    }

    getCrossSaleHotelsV1(
        params: IGetCrossSaleHotelsRequestParamsV1,
    ): Promise<IGetCrossSaleHotelsResponseV1> {
        return this.get<IGetCrossSaleHotelsResponseV1>(
            '/v1/get_cross_sale_hotels',
            {
                params,
            },
        );
    }

    getCrossSaleHotelsV3(
        params: IGetCrossSaleHotelsRequestParamsV3,
    ): Promise<IGetCrossSaleHotelsResponseV3> {
        return this.get<IGetCrossSaleHotelsResponseV3>(
            '/v3/get_cross_sale_hotels',
            {
                params,
            },
        );
    }

    protected async interceptRequest(request: IRequestConfig): Promise<void> {
        request.timeout = 25000;
        request.headers = {
            ...request.headers,
            [CommonHeaders.X_YA_SERVICE_TICKET]: this.serviceTicket,
            [CommonHeaders.X_YA_USE_CAMELCASE]: 'true',
        };
    }
}
