import IPrice from 'types/common/price/IPrice';
import {MapBoundsType} from 'types/common/ICoordinates';
import {IGeoRegion} from 'types/hotels/hotel/IGeoRegion';
import {IHotelWithMinPrice} from 'types/hotels/hotel/IHotelWithMinPrice';

export default interface IGetCrossSaleHotelsResponseV1 {
    /**
     * Есть ли данные для указанного в запросе региона. Если true, то поля ниже заполнены, иначе - пусты.
     *
     * @depricated при наличии этого поля остальные поля приходят как null, что не соотвествует спеке. Нужно отказаться от этого поля и либо не возвращать этот блок в массиве при запросе SEO страниц, либо возвращать 404 при отдельном запросе этого блока
     */
    hasData: boolean;
    /* Информация об изначальном регионе поиска, соответствует geoId из запроса */
    region: IGeoRegion;
    /* Минимальная цена на отели в searchRegion */
    minPriceInRegion: IPrice;
    /* Ограничивающий прямоугольник для карты в виде строки */
    bboxAsString: string; // 37.0408809,55.311850~38.20412732,56.18961995; // lon,lat~lon,lat
    /* Ограничивающий прямоугольник для карты в виде списка */
    bboxAsStruct: MapBoundsType;
    /* Список отелей в этом регионе, не больше, чем totalHotelLimit в запросе */
    hotels: IHotelWithMinPrice[];
    /* Сколько всего отелей в регионе, без учёта totalHotelLimit */
    totalHotelCount: number;
    /* Ссылка на картинку региона. Если фотографии региона нет - ссылка на картинку-заглушку */
    regionImageUrl: string;
}
