import moment from 'moment';
import {
    CANCELLED,
    IN_PROGRESS,
    CONFIRMED,
    REFUNDED,
    AWAITS_PAYMENT,
    RESERVED,
    FAILED,
} from 'projects/hotels/constants/hotelsBookingStatuses';
import {
    IExtranetOrderInfo,
    IHotelsExtranetOrdersResponse,
} from '../types/IHotelsExtranetOrdersResponse';
import {CurrencyType} from 'utilities/currency/CurrencyType';
import {ROBOT} from 'utilities/dateUtils/formats';
import {times} from 'lodash';
import {IHotelsExtranetOrdersRequest} from '../types/IHotelsExtranetOrdersRequest';

const names = [
    'Василий',
    'Александр',
    'Искандер',
    'Петр',
    'Николай',
    'Семен',
    'Иван',
    'Максим',
    'Ильяс',
    'Гурбангулы',
];
const lastNames = [
    'Попов',
    'Иванов',
    'Сидоров',
    'Романов',
    'Ли',
    'Музалевский',
    'Шарапов',
    'Бердымухамедов',
];

const statuses = [
    CANCELLED,
    IN_PROGRESS,
    CONFIRMED,
    REFUNDED,
    AWAITS_PAYMENT,
    RESERVED,
    FAILED,
];

const statusesLocalized = ['Отменен', 'Выполнен', 'Оплачен'];

export const getOrderInfoMock = (): IExtranetOrderInfo => {
    const id = `${Math.ceil(Math.random() * 10000000 + 1000000)}`;
    const partnerOrderId = `${Math.ceil(Math.random() * 10000000 + 1000000)}`;
    const price = Math.random() * 100000 + 10000;
    const fee = Math.random() * 10000;
    const date = moment().add('month', Math.random());

    return {
        id: id.substr(0, 10),
        partnerOrderId: partnerOrderId.substr(0, 10),
        prettyId: `YA-${id}`,
        firstGuest: {
            firstName: names[Math.floor(Number(Math.random()) * names.length)],
            lastName:
                lastNames[Math.floor(Number(Math.random()) * lastNames.length)],
        },
        status: statuses[Math.floor(Number(Math.random()) * statuses.length)],
        statusLocalized:
            statusesLocalized[
                Math.floor(Number(Math.random()) * statusesLocalized.length)
            ],
        createdAt: date.format(ROBOT),
        cancelledAt: date.add('day', Math.random()).format(ROBOT),
        checkInDate: date.add('day', Math.random()).format(ROBOT),
        checkOutDate: date.add('day', Math.random()).format(ROBOT),
        updatedAt: date.add('day', Math.random()).format(ROBOT),
        priceBreakdown: {
            fiscalPrice: {
                value: price - fee,
                currency: CurrencyType.RUB,
            },
            hotelPrice: {
                value: price,
                currency: CurrencyType.RUB,
            },
            discount: {
                value: 10,
                currency: CurrencyType.RUB,
            },

            fee: {
                value: fee,
                currency: CurrencyType.RUB,
            },
            partner: {
                value: 1000,
                currency: CurrencyType.RUB,
            },

            payoutAt: date.add('day', Math.random()).format(ROBOT),
        },
        bankOrderInfo: [{bankOrderId: 'AAAAAA-AAAAAA-AAAAA'}],
    };
};

export const getOrdersMockResponse = (
    request: IHotelsExtranetOrdersRequest,
): IHotelsExtranetOrdersResponse => {
    const pageSize = request.page?.limit || 10;
    const result: IExtranetOrderInfo[] = times(pageSize, getOrderInfoMock);
    return {
        partnerSum: {value: 34234223, currency: CurrencyType.RUB},
        fiscalSum: {value: 34234223, currency: CurrencyType.RUB},
        feeSum: {value: 42393, currency: CurrencyType.RUB},
        result,
        page: Number(request.page || 1),
        totalRecords: 6343,
    };
};
