import {times} from 'lodash';
import moment from 'moment';
import {CurrencyType} from 'utilities/currency/CurrencyType';
import {ROBOT} from 'utilities/dateUtils/formats';
import {
    IBankOrderInfoDetail,
    IHotelsExtranetPaymentDetailsResponse,
    TTransactionType,
} from '../types/IHotelsExtranetPaymentDetailsResponse';

const TRANSACTION_TYPES: TTransactionType[] = ['BTTT_PAYMENT', 'BTTT_REFUND'];

const getPaymentDetailMock = (): IBankOrderInfoDetail => {
    const fiscalPrice = Math.random() * 100000 + 10000;
    const id = Math.ceil(Math.random() * 10000000 + 1000000);

    return {
        priceBreakdown: {
            hotelPrice: {value: fiscalPrice * 0.9, currency: CurrencyType.RUB},
            fiscalPrice: {value: fiscalPrice, currency: CurrencyType.RUB},
            discount: {value: fiscalPrice * 0.05, currency: CurrencyType.RUB},
            fee: {value: fiscalPrice * 0.1, currency: CurrencyType.RUB},
            partner: {value: fiscalPrice * 0.9, currency: CurrencyType.RUB},
        },
        orderCreatedAt: moment().add(Math.random(), 'month').format(ROBOT),
        checkInDate: moment().add(Math.random(), 'month').format(ROBOT),
        checkOutDate: moment().add(Math.random(), 'month').format(ROBOT),
        transactionType:
            TRANSACTION_TYPES[
                Math.floor(TRANSACTION_TYPES.length * Math.random())
            ],
        orderPrettyId: id.toString(),
        orderId: id.toString(),
        firstGuest: {
            firstName: 'Test',
            lastName: 'Guest',
        },
    };
};

export const getPaymentDetailsMock =
    (): IHotelsExtranetPaymentDetailsResponse => {
        const sum = Math.random() * 100000 + 10000;
        return {
            result: times(
                Math.floor(Math.random() * 6 + 2),
                getPaymentDetailMock,
            ),
            sum: {value: sum, currency: CurrencyType.RUB},
        };
    };
