import {times} from 'lodash';
import moment from 'moment';
import {CurrencyType} from 'utilities/currency/CurrencyType';

import {ROBOT} from 'utilities/dateUtils/formats';

import {IHotelsExtranetPaymentsRequest} from '../types/IHotelsExtranetPaymentsRequest';
import {
    IExtranetPaymentInfo,
    IHotelsExtranetPaymentsResponse,
} from '../types/IHotelsExtranetPaymentsResponse';

const getPaymentInfoMock = (): IExtranetPaymentInfo => {
    const id = `${Math.ceil(Math.random() * 10000000 + 1000000)}`;
    const sum = Math.random() * 100000 + 10000;
    const date = moment().add('month', Math.random());

    return {
        paymentBatchId: id.substr(0, 10),
        bankOrderId: id.substr(0, 10),
        sum: {value: sum, currency: CurrencyType.RUB},
        eventTime: date.format(ROBOT),
        status: 'status',
        localizedStatus: 'localizedStatus',
        description: '',
    };
};

export const getPaymentsMockResponse = (
    request: IHotelsExtranetPaymentsRequest,
): IHotelsExtranetPaymentsResponse => {
    const pageSize = request.page?.limit || 10;
    const result: IExtranetPaymentInfo[] = times(pageSize, getPaymentInfoMock);
    return {
        result,
        page: Number(request.page || 1),
        totalRecords: 423,
        sum: {value: 32233, currency: CurrencyType.RUB},
    };
};
