import {IDateFilter} from './IDateFilter';
import {IPageable} from './IPageable';
import {ISortBy} from './ISortBy';

export type TSortFieldName =
    | 'fiscalPrice'
    | 'feeAmount'
    | 'partnerAmount'
    | 'checkOutDate'
    | 'checkInDate'
    | 'cancelledAt'
    | 'createdAt';

export interface IHotelsExtranetOrdersFilters {
    checkInDate?: IDateFilter;
    checkOutDate?: IDateFilter;
    orderedAt?: IDateFilter;
    cancelledAt?: IDateFilter;
}

export interface IHotelsExtranetOrdersRequest
    extends IHotelsExtranetOrdersFilters {
    originalId: string;
    partnerId: string;
    orderStatus?: EExtranetOrderStatus[];

    page: IPageable;
    sortFields?: ISortBy<TSortFieldName>[];
}

export enum EExtranetOrderStatus {
    EOS_UNKNOWN = 'EOS_UNKNOWN',
    EOS_PREPAID = 'EOS_PREPAID',
    EOS_AWAITS_PAYMENT = 'EOS_AWAITS_PAYMENT',
    EOS_REFUNDED = 'EOS_REFUNDED',
    EOS_SERVED = 'EOS_SERVED',
}
