import {IHotelGuest} from 'server/api/HotelsBookAPI/types/IOrder';
import IPrice from 'types/common/price/IPrice';

import {IPriceBreakdown} from './IPriceBreakdown';
import {ITableData} from './ITableData';

export interface IHotelsExtranetOrdersResponse
    extends ITableData<IExtranetOrderInfo> {
    feeSum: IPrice;
    /** сумма оплат отелю того что на странице */
    partnerSum: IPrice;
    /** сумма того что показали пользователю (без скидки) */
    fiscalSum: IPrice;
}

export interface IExtranetOrderInfo {
    /** guid */
    id: string;
    /** YA-1111-1111-1111 */
    prettyId: string;
    /** номер заказа у Travelline/BNovo */
    partnerOrderId: string;
    /** Имя 1-го гостя */
    firstGuest: IHotelGuest;
    // TODO верифицировать выбор статусов, возможно имеет смысл сделать новый набор статусов
    status: string;
    statusLocalized: string;
    /** дата бронирования */
    createdAt: string;
    /** дата обновления заказа */
    updatedAt: string;
    /** дата отмены */
    cancelledAt?: string;

    /** проживание с */
    checkInDate: string;
    /** проживание до */
    checkOutDate: string;

    /** денежные поля */
    priceBreakdown: IPriceBreakdown;
    /** информация о п/п */
    bankOrderInfo: IBankOrderInfo[];
}

interface IBankOrderInfo {
    bankOrderId: string;
}
