import IPrice from 'types/common/price/IPrice';
import {IHotelGuest} from 'server/api/HotelsBookAPI/types/IOrder';

import {IPriceBreakdown} from './IPriceBreakdown';

export interface IHotelsExtranetPaymentDetailsResponse {
    result: IBankOrderInfoDetail[];
    /** сумма посчитанная по result. Должно совпадать  с суммой п/п, но могут быть случаи, когда
     * не совпадает */
    sum: IPrice;
}

export type TTransactionType = 'BTTT_PAYMENT' | 'BTTT_REFUND';

/** конкретная строчка в расшивроке п/п, может быть привязана к одному заказу */
export interface IBankOrderInfoDetail {
    /**
     * Тип транзакции. (BillingTransactionType)
     * PAYMENT - платит пользователь
     * REFUND - возвращаем деньги пользователю.
     *
     * Если REFUND - какие-то суммы надо отображать с минусом, с бэка передаются положительные.
     */
    transactionType: TTransactionType;

    orderId: string;
    orderPrettyId: string;

    firstGuest?: IHotelGuest;

    orderCreatedAt: string;
    checkInDate: string;
    checkOutDate: string;

    /**
     * Содержит только hotelPrice, fiscalPrice, partner
     */
    priceBreakdown: IPriceBreakdown;
}
