import IPrice from 'types/common/price/IPrice';

import {ISortBy} from './ISortBy';
import {ITableData} from './ITableData';

export type TSortFieldName = 'bankOrderId' | 'sum' | 'eventTime';

export interface IHotelsExtranetPaymentsResponse
    extends ITableData<IExtranetPaymentInfo> {
    sortFields?: ISortBy<TSortFieldName>[];
    /** Сумма того что пользователь видит на странице */
    sum: IPrice;
}

export interface IExtranetPaymentInfo {
    paymentBatchId: string;
    /** номер п/п */
    bankOrderId: string;
    /** Дата платежа. */
    eventTime: string;
    /** номер п/п */
    status: string;
    /** TBD */
    localizedStatus?: string;
    /** сумма. для API "строка", но, естественно, это число */
    sum: IPrice;
    /** многословное описание п/п, получаем от биллинга */
    description: string;
}
