import IPrice from 'types/common/price/IPrice';

export interface IPriceBreakdown {
    // TODO возможно стоит пересмотреть передачу цены в IPrice с валютой в каждом поле

    /** полная цена для пользователя*/
    fiscalPrice: IPrice;
    /** цена от отеля (чаще совпадает с fiscal price), но бывают приколы с копейками */
    hotelPrice?: IPrice;
    /** полная скидка (и по промокодам, и по специальным программам). Сумма от пользователя = fiscalPrice - discount */
    discount: IPrice;

    // поля ниже nullable потому что они считаются с некоторой задержкой. Мы не пытаемся пересчитывать их вне оркестратора.
    /** комиссия яндекса */
    fee?: IPrice;
    /** сумма брони к перечислению (fiscalPrice-fee) */
    partner?: IPrice;

    /** дата оплаты партнеру */
    payoutAt?: string;
}
