import {PermalinkType} from 'types/hotels/hotel/IHotel';
import {
    IRequiredOfferParams,
    IDebugOfferSearchParams,
} from 'types/hotels/offer/IHotelOffer';
import {IHotelsAttributionParams} from 'types/hotels/common/IAttribution';

export default interface IGetFavoriteHotelsOffersRequestParams
    extends IRequiredOfferParams,
        Partial<IDebugOfferSearchParams>,
        IHotelsAttributionParams {
    /** Домен для транслокальности. */
    domain?: string;

    // Контекст поллинга
    context: string;
    // Номер итерации поллинга фронта (для отладки и аналитики).
    pollIteration: number;

    // Оффера этих пермалинков хотим получить
    permalinks: PermalinkType[];
}
