import {
    IRequiredOfferParams,
    IHotelOfferSearchProgress,
} from 'types/hotels/offer/IHotelOffer';
import IFavoriteCategory from 'projects/favorites/types/IFavoriteCategory';
import {PermalinkType} from 'types/hotels/hotel/IHotel';
import {IShortHotelOffersInfo} from 'types/hotels/hotel/IHotelWithOffers';
import {IExtraVisitAndUserParams} from 'types/hotels/common/IExtraVisitAndUserParams';

export default interface IGetFavoriteHotelsOffersResponse {
    // Состояние параметров поиска предложений.
    offerSearchParams: IRequiredOfferParams;

    offerSearchProgress: IHotelOfferSearchProgress;
    nextPollingRequestDelayMs?: number; // Заполнено, если offerSearchProgress.finished == false. Минимальное значение - 200ms

    /** Нужно передать в последющие запросы в getHotelOffers */
    context: string;

    /** Категория этого списка (нужна для заголовка на странице) */
    category: IFavoriteCategory;

    /** Информация обо всех запрошенных пермалинках: и завершённых, и нет */
    offers: Record<PermalinkType, IShortHotelOffersInfo>;

    extraVisitAndUserParams: IExtraVisitAndUserParams;
}
