import {
    IRequiredOfferParams,
    IDebugOfferSearchParams,
} from 'types/hotels/offer/IHotelOffer';
import {IHotelsAttributionParams} from 'types/hotels/common/IAttribution';

export default interface IGetFavoriteHotelsRequestParams
    extends Partial<IRequiredOfferParams>,
        Partial<IDebugOfferSearchParams>,
        IHotelsAttributionParams {
    /** Домен для транслокальности. */
    domain?: string;
    /**
     * Id выбранной категории
     * Если не указана, будет выбрано значение по умолчанию
     */
    categoryId?: string;

    /** Сколько фотографий вернуть. По умолчанию - все. */
    imageLimit?: number;
    /** Размеры фотографий, которые надо вернуть. По умолчанию - все. */
    imageSizes?: string[];

    /** Для паджинации */
    /** Сколько отелей пропустить */
    offset: number;
    /** Сколько отелей вернуть (максимум) */
    limit: number;

    withInfiniteScroll?: boolean;
}
