import {IHotelWithOffers} from 'types/hotels/hotel/IHotelWithOffers';
import {IExtraVisitAndUserParams} from 'types/hotels/common/IExtraVisitAndUserParams';
import {
    IRequiredOfferParams,
    IHotelOfferSearchProgress,
} from 'types/hotels/offer/IHotelOffer';
import IFavoriteCategory from 'projects/favorites/types/IFavoriteCategory';

export default interface IGetFavoriteHotelsResponse {
    data: {
        /** Состояние параметров поиска предложений. */
        offerSearchParams: IRequiredOfferParams;

        offerSearchProgress: IHotelOfferSearchProgress;
        nextPollingRequestDelayMs?: number; // Заполнено, если offerSearchProgress.finished == false. Минимальное значение - 200ms

        /** Контекст поллинга, нужно передать в следующие запросы в getHotelOffers, если они будут */
        context: string;

        /** Id выбранной категории (может отличаться от переданного в запросе) */
        selectedCategoryId: string;

        /** Все доступные категории. Обязательно содержит категорию с id == category */
        categories: IFavoriteCategory[];

        hotels: IHotelWithOffers[];
        totalHotelCount: number;

        extraVisitAndUserParams: IExtraVisitAndUserParams;
    };
    withInfiniteScroll?: boolean;
}
