import {
    IRequiredOfferParams,
    IHotelOfferSearchProgress,
} from 'types/hotels/offer/IHotelOffer';
import {IHotelWithOffers} from 'types/hotels/hotel/IHotelWithOffers';
import {IExtraVisitAndUserParams} from 'types/hotels/common/IExtraVisitAndUserParams';

export default interface IGetSharedFavoriteHotelsResponse {
    /** Состояние параметров поиска предложений. */
    offerSearchParams: IRequiredOfferParams;

    offerSearchProgress: IHotelOfferSearchProgress;
    nextPollingRequestDelayMs?: number; // Заполнено, если offerSearchProgress.finished == false. Минимальное значение - 200ms

    /** Контекст поллинга, нужно передать в следующие запросы в getHotelOffers, если они будут */
    context: string;

    hotels: IHotelWithOffers[];
    totalHotelCount: number;

    extraVisitAndUserParams: IExtraVisitAndUserParams;
}
