import {IGeoRegionInfoResponse} from '../types/IGeoRegionInfo';
import {MainAmenityIdType} from 'types/hotels/hotel/IHotel';
import {EGeoRegionBlockType} from 'types/hotels/geoRegion/IGeoRegionInfo';
import {
    ETextBlocksType,
    EPlainTextStyle,
} from 'types/common/seoPages/ITextBlocks';
import {EHotelBadgeType} from 'types/hotels/offer/IHotelOffer';

import {CURRENCY_RUB} from 'utilities/currency/codes';
import {CurrencyType} from 'utilities/currency/CurrencyType';

const geoRegionResponse: IGeoRegionInfoResponse = {
    seoInfo: {
        title: 'Отели в Сочи',
        description: 'Отели в Сочи с кошками',
        openGraph: {
            title: 'openGraph название страницы',
            description: 'openGraph описание страницы',
            image: 'https://avatars.mds.yandex.net/get-altay/1860543/2a0000016f76e6ef2964853a440b016ea007/orig',
            imageSize: {
                height: 200,
                width: 200,
            },
        },
        schemaOrg: {
            faqItems: [
                {
                    question: 'Кто в Москве не бывал',
                    answer: 'Красоты не видал.',
                },
                {
                    question: 'Ну Татарин!',
                    answer: 'Жизнь висит на нитке, а думает о прибытке.',
                },
            ],
        },
    },
    blocks: [
        {
            type: EGeoRegionBlockType.SEARCH_FORM_BLOCK,
            data: {
                title: 'Отели в Сочи',
                imageUrl:
                    'https://avatars.mds.yandex.net/get-altay/1860543/2a0000016f76e6ef2964853a440b016ea007/orig',
                searchFormParams: {
                    isCalendarOpen: true,
                    regionSlug: 'moscow',
                },
            },
        },
        {
            type: EGeoRegionBlockType.HOTELS_BLOCK,
            data: {
                title: 'Отели с кошками',
                searchButtonText: 'Все отели с кошками',
                searchParams: {
                    filterParams: {},
                },
                region: {
                    geoId: 213,
                    slug: 'moscow',
                    linguistics: {
                        ablativeCase: '',
                        accusativeCase: 'Москву',
                        dativeCase: 'Москве',
                        directionalCase: '',
                        genitiveCase: 'Москвы',
                        instrumentalCase: 'Москвой',
                        locativeCase: '',
                        nominativeCase: 'Москва',
                        preposition: 'в',
                        prepositionalCase: 'Москве',
                    },
                },
                hotels: [
                    {
                        hotel: {
                            permalink: '1019057204',
                            hotelSlug: 'moscow/vega-izmailovo',
                            name: 'Marriott Grand Hotel',
                            category: {id: 'hotels', name: 'Гостиница'},
                            coordinates: {
                                lat: 55.768322,
                                lon: 37.599392,
                            },
                            address: 'Россия, Москва, Тверская улица, 26/1',
                            stars: 5,
                            rating: 5,
                            totalTextReviewCount: 315,
                            totalImageCount: 139,
                            images: [
                                {
                                    urlTemplate:
                                        'https://avatars.mds.yandex.net/get-altay/492546/2a0000015fdc1509311f2ce61d539f0187e4/%s',
                                    id: 'urn:yandex:sprav:photo:7805558',
                                    sizes: [
                                        {
                                            size: 'XXXS',
                                            height: 32,
                                            width: 50,
                                        },
                                        {
                                            size: 'XXS',
                                            height: 48,
                                            width: 75,
                                        },
                                        {
                                            size: 'XS',
                                            height: 64,
                                            width: 100,
                                        },
                                        {size: 'S', height: 96, width: 150},
                                        {
                                            size: 'M',
                                            height: 192,
                                            width: 300,
                                        },
                                        {size: 'L', height: 319, width: 500},
                                        {
                                            size: 'XL',
                                            height: 511,
                                            width: 800,
                                        },
                                        {size: 'XXL', height: 511, width: 800},
                                        {
                                            size: 'XXXL',
                                            height: 511,
                                            width: 800,
                                        },
                                        {size: 'orig', height: 511, width: 800},
                                    ],
                                    tags: ['Interior'],
                                },
                            ],
                            mainAmenities: [
                                {
                                    id: MainAmenityIdType.WI_FI,
                                    name: 'Модем',
                                },
                                {
                                    id: MainAmenityIdType.POOL,
                                    name: 'Можно пьяным в бассейн',
                                },
                                {
                                    id: MainAmenityIdType.CAR_PARK,
                                    name: 'Парковка',
                                },
                                {
                                    id: MainAmenityIdType.AIR_CONDITIONING,
                                    name: 'Прохладно там где надо',
                                },
                                {
                                    id: MainAmenityIdType.GYM,
                                    name: 'На спортике',
                                },
                                {
                                    id: MainAmenityIdType.PAYMENT_BY_CARD,
                                    name: 'Оплата картой',
                                },
                                {
                                    id: MainAmenityIdType.BEACH_LINE,
                                    name: 'Ещё и пляж недалеко',
                                },
                            ],
                            isFavorite: false,
                        },
                        minPrice: {
                            value: 2222,
                            currency: CURRENCY_RUB,
                        },
                        hasOfferYandexPlus: true,
                        badges: [
                            {
                                id: EHotelBadgeType.TAXI_PROMOCODE,
                                text: 'Промокод на такси',
                            },
                        ],
                    },
                    {
                        hotel: {
                            permalink: '1019fd057204',
                            hotelSlug: 'moscow/vega-izmailovo',
                            name: 'Grand',
                            category: {id: 'hotels', name: 'Гостиница'},
                            coordinates: {
                                lat: 55.768322,
                                lon: 37.599392,
                            },
                            address: 'Россия, Москва, Тверская улица, 26/1',
                            stars: 2,
                            rating: 4,
                            totalTextReviewCount: 100,
                            totalImageCount: 139,
                            images: [
                                {
                                    urlTemplate:
                                        'https://avatars.mds.yandex.net/get-altay/758053/2a00000161571db25bde344add504bfc30ac/%s',
                                    id: 'urn:yandex:sprav:photo:7805558',
                                    sizes: [
                                        {
                                            size: 'XXXS',
                                            height: 32,
                                            width: 50,
                                        },
                                        {
                                            size: 'XXS',
                                            height: 48,
                                            width: 75,
                                        },
                                        {
                                            size: 'XS',
                                            height: 64,
                                            width: 100,
                                        },
                                        {size: 'S', height: 96, width: 150},
                                        {
                                            size: 'M',
                                            height: 192,
                                            width: 300,
                                        },
                                        {size: 'L', height: 319, width: 500},
                                        {
                                            size: 'XL',
                                            height: 511,
                                            width: 800,
                                        },
                                        {size: 'XXL', height: 511, width: 800},
                                        {
                                            size: 'XXXL',
                                            height: 511,
                                            width: 800,
                                        },
                                        {size: 'orig', height: 511, width: 800},
                                    ],
                                    tags: ['Interior'],
                                },
                            ],
                            mainAmenities: [
                                {
                                    id: MainAmenityIdType.WI_FI,
                                    name: 'Модем',
                                },
                                {
                                    id: MainAmenityIdType.POOL,
                                    name: 'Можно пьяным в бассейн',
                                },
                                {
                                    id: MainAmenityIdType.CAR_PARK,
                                    name: 'Парковка',
                                },
                                {
                                    id: MainAmenityIdType.AIR_CONDITIONING,
                                    name: 'Прохладно там где надо',
                                },
                                {
                                    id: MainAmenityIdType.GYM,
                                    name: 'На спортике',
                                },
                                {
                                    id: MainAmenityIdType.PAYMENT_BY_CARD,
                                    name: 'Оплата картой',
                                },
                                {
                                    id: MainAmenityIdType.BEACH_LINE,
                                    name: 'Ещё и пляж недалеко',
                                },
                            ],
                            isFavorite: false,
                        },
                        minPrice: {
                            value: 232,
                            currency: CURRENCY_RUB,
                        },
                        hasOfferYandexPlus: false,
                    },
                ],
            },
        },
        {
            type: EGeoRegionBlockType.HOTELS_BLOCK,
            data: {
                title: 'Отели с собаками',
                searchButtonText: 'Все отели с собаками',
                searchParams: {
                    filterParams: {},
                },
                region: {
                    geoId: 213,
                    slug: 'moscow',
                    linguistics: {
                        ablativeCase: '',
                        accusativeCase: 'Москву',
                        dativeCase: 'Москве',
                        directionalCase: '',
                        genitiveCase: 'Москвы',
                        instrumentalCase: 'Москвой',
                        locativeCase: '',
                        nominativeCase: 'Москва',
                        preposition: 'в',
                        prepositionalCase: 'Москве',
                    },
                },
                hotels: [
                    {
                        hotel: {
                            permalink: '101905723204',
                            hotelSlug: 'moscow/vega-izmailovo',
                            name: 'Hotel',
                            category: {id: 'hotels', name: 'Гостиница'},
                            coordinates: {
                                lat: 55.768322,
                                lon: 37.599392,
                            },
                            address: 'Россия, Москва, Тверская улица, 26/1',
                            stars: 5,
                            rating: 5,
                            totalTextReviewCount: 1315,
                            totalImageCount: 1393,
                            images: [
                                {
                                    urlTemplate:
                                        'https://avatars.mds.yandex.net/get-altay/1705560/2a0000016fd2d3f4342638607f57f9bf277c/%s',
                                    id: 'urn:yandex:sprav:photo:7805558',
                                    sizes: [
                                        {
                                            size: 'XXXS',
                                            height: 32,
                                            width: 50,
                                        },
                                        {
                                            size: 'XXS',
                                            height: 48,
                                            width: 75,
                                        },
                                        {
                                            size: 'XS',
                                            height: 64,
                                            width: 100,
                                        },
                                        {size: 'S', height: 96, width: 150},
                                        {
                                            size: 'M',
                                            height: 192,
                                            width: 300,
                                        },
                                        {size: 'L', height: 319, width: 500},
                                        {
                                            size: 'XL',
                                            height: 511,
                                            width: 800,
                                        },
                                        {size: 'XXL', height: 511, width: 800},
                                        {
                                            size: 'XXXL',
                                            height: 511,
                                            width: 800,
                                        },
                                        {size: 'orig', height: 511, width: 800},
                                    ],
                                    tags: ['Interior'],
                                },
                            ],
                            mainAmenities: [
                                {
                                    id: MainAmenityIdType.WI_FI,
                                    name: 'Модем',
                                },
                                {
                                    id: MainAmenityIdType.POOL,
                                    name: 'Можно пьяным в бассейн',
                                },
                                {
                                    id: MainAmenityIdType.CAR_PARK,
                                    name: 'Парковка',
                                },
                                {
                                    id: MainAmenityIdType.AIR_CONDITIONING,
                                    name: 'Прохладно там где надо',
                                },
                                {
                                    id: MainAmenityIdType.GYM,
                                    name: 'На спортике',
                                },
                                {
                                    id: MainAmenityIdType.PAYMENT_BY_CARD,
                                    name: 'Оплата картой',
                                },
                                {
                                    id: MainAmenityIdType.BEACH_LINE,
                                    name: 'Ещё и пляж недалеко',
                                },
                            ],
                            isFavorite: false,
                        },
                        minPrice: {
                            value: 123,
                            currency: CURRENCY_RUB,
                        },
                    },
                    {
                        hotel: {
                            permalink: '101239fd057204',
                            hotelSlug: 'moscow/vega-izmailovo',
                            name: 'Gr',
                            category: {id: 'hotels', name: 'Гостиница'},
                            coordinates: {
                                lat: 55.768322,
                                lon: 37.599392,
                            },
                            address: 'Россия, Москва, Тверская улица, 26/1',
                            stars: 2,
                            rating: 4,
                            totalTextReviewCount: 100,
                            totalImageCount: 139,
                            images: [
                                {
                                    urlTemplate:
                                        'https://avatars.mds.yandex.net/get-altay/1974402/2a0000016fd2d3f671e330b8976184f08ac4/%s',
                                    id: 'urn:yandex:sprav:photo:7805558',
                                    sizes: [
                                        {
                                            size: 'XXXS',
                                            height: 32,
                                            width: 50,
                                        },
                                        {
                                            size: 'XXS',
                                            height: 48,
                                            width: 75,
                                        },
                                        {
                                            size: 'XS',
                                            height: 64,
                                            width: 100,
                                        },
                                        {size: 'S', height: 96, width: 150},
                                        {
                                            size: 'M',
                                            height: 192,
                                            width: 300,
                                        },
                                        {size: 'L', height: 319, width: 500},
                                        {
                                            size: 'XL',
                                            height: 511,
                                            width: 800,
                                        },
                                        {size: 'XXL', height: 511, width: 800},
                                        {
                                            size: 'XXXL',
                                            height: 511,
                                            width: 800,
                                        },
                                        {size: 'orig', height: 511, width: 800},
                                    ],
                                    tags: ['Interior'],
                                },
                                {
                                    urlTemplate:
                                        'https://avatars.mds.yandex.net/get-altay/1974402/2a0000016fd2d3f671e330b8976184f08ac4/%s',
                                    id: 'urn:yandex:sprav:photo:7805558',
                                    sizes: [
                                        {
                                            size: 'XXXS',
                                            height: 32,
                                            width: 50,
                                        },
                                        {
                                            size: 'XXS',
                                            height: 48,
                                            width: 75,
                                        },
                                        {
                                            size: 'XS',
                                            height: 64,
                                            width: 100,
                                        },
                                        {size: 'S', height: 96, width: 150},
                                        {
                                            size: 'M',
                                            height: 192,
                                            width: 300,
                                        },
                                        {size: 'L', height: 319, width: 500},
                                        {
                                            size: 'XL',
                                            height: 511,
                                            width: 800,
                                        },
                                        {size: 'XXL', height: 511, width: 800},
                                        {
                                            size: 'XXXL',
                                            height: 511,
                                            width: 800,
                                        },
                                        {size: 'orig', height: 511, width: 800},
                                    ],
                                    tags: ['Interior'],
                                },
                                {
                                    urlTemplate:
                                        'https://avatars.mds.yandex.net/get-altay/1974402/2a0000016fd2d3f671e330b8976184f08ac4/%s',
                                    id: 'urn:yandex:sprav:photo:7805558',
                                    sizes: [
                                        {
                                            size: 'XXXS',
                                            height: 32,
                                            width: 50,
                                        },
                                        {
                                            size: 'XXS',
                                            height: 48,
                                            width: 75,
                                        },
                                        {
                                            size: 'XS',
                                            height: 64,
                                            width: 100,
                                        },
                                        {size: 'S', height: 96, width: 150},
                                        {
                                            size: 'M',
                                            height: 192,
                                            width: 300,
                                        },
                                        {size: 'L', height: 319, width: 500},
                                        {
                                            size: 'XL',
                                            height: 511,
                                            width: 800,
                                        },
                                        {size: 'XXL', height: 511, width: 800},
                                        {
                                            size: 'XXXL',
                                            height: 511,
                                            width: 800,
                                        },
                                        {size: 'orig', height: 511, width: 800},
                                    ],
                                    tags: ['Interior'],
                                },
                            ],
                            mainAmenities: [
                                {
                                    id: MainAmenityIdType.WI_FI,
                                    name: 'Модем',
                                },
                                {
                                    id: MainAmenityIdType.POOL,
                                    name: 'Можно пьяным в бассейн',
                                },
                                {
                                    id: MainAmenityIdType.CAR_PARK,
                                    name: 'Парковка',
                                },
                                {
                                    id: MainAmenityIdType.AIR_CONDITIONING,
                                    name: 'Прохладно там где надо',
                                },
                                {
                                    id: MainAmenityIdType.GYM,
                                    name: 'На спортике',
                                },
                                {
                                    id: MainAmenityIdType.PAYMENT_BY_CARD,
                                    name: 'Оплата картой',
                                },
                                {
                                    id: MainAmenityIdType.BEACH_LINE,
                                    name: 'Ещё и пляж недалеко',
                                },
                            ],
                            isFavorite: false,
                        },
                        minPrice: {
                            value: 99,
                            currency: CURRENCY_RUB,
                        },
                    },
                ],
            },
        },
        {
            type: ETextBlocksType.sectionTextBlock,
            data: {},
            children: [
                {
                    type: ETextBlocksType.textBlock,
                    children: [
                        {
                            type: ETextBlocksType.plainTextBlock,
                            data: {
                                text: 'Город? Город - страшная сила. А чем больше город, тем она сильнее. Он засасывает. Только сильный может выкарабкаться.',
                            },
                        },
                    ],
                },
            ],
        },
        {
            type: ETextBlocksType.sectionTextBlock,
            data: {
                title: 'В Москве вся сила',
            },
            children: [
                {
                    type: ETextBlocksType.textBlock,
                    children: [
                        {
                            type: ETextBlocksType.plainTextBlock,
                            data: {
                                text: 'Город - ',
                            },
                        },
                        {
                            type: ETextBlocksType.plainTextBlock,
                            data: {
                                text: 'злая ',
                                styles: [EPlainTextStyle.bold],
                            },
                        },
                        {
                            type: ETextBlocksType.plainTextBlock,
                            data: {
                                text: 'сила. Сильный приезжает, становится ',
                            },
                        },
                        {
                            type: ETextBlocksType.plainTextBlock,
                            data: {
                                text: 'слабым. ',
                                styles: [EPlainTextStyle.italic],
                            },
                        },
                        {
                            type: ETextBlocksType.plainTextBlock,
                            data: {
                                text: 'Город забирает силу. Вот и ты ',
                            },
                        },
                        {
                            type: ETextBlocksType.plainTextBlock,
                            data: {
                                text: 'пропал.',
                                styles: [
                                    EPlainTextStyle.italic,
                                    EPlainTextStyle.bold,
                                ],
                            },
                        },
                    ],
                },
                {
                    type: ETextBlocksType.subSectionTextBlock,
                    data: {
                        title: 'Ты тут разгребай и в Москву',
                    },
                    children: [
                        {
                            type: ETextBlocksType.textBlock,
                            children: [
                                {
                                    type: ETextBlocksType.plainTextBlock,
                                    data: {
                                        text: 'В общем, дело непростое. Ты присмотрись, подумай, как уйти. А денег я лучше тебе дам. ',
                                    },
                                },
                                {
                                    type: ETextBlocksType.priceTextBlock,
                                    data: {
                                        price: {
                                            currency: CurrencyType.USD,
                                            value: 2000,
                                        },
                                    },
                                },
                                {
                                    type: ETextBlocksType.plainTextBlock,
                                    data: {
                                        text: ' баксов. Ко мне больше не ходи - опасно. Вот тебе ствол с обоймой. Это еще шестьсот.',
                                    },
                                },
                            ],
                        },
                    ],
                },
                {
                    type: ETextBlocksType.subSectionTextBlock,
                    data: {
                        title: 'Не Ленинград, а Петербург',
                    },
                    children: [
                        {
                            type: ETextBlocksType.textBlock,
                            children: [
                                {
                                    type: ETextBlocksType.regionLinkBlock,
                                    data: {
                                        text: 'Питер. ',
                                        urlParams: {
                                            regionSlug: 'piter',
                                        },
                                    },
                                },
                                {
                                    type: ETextBlocksType.plainTextBlock,
                                    data: {
                                        text: 'Красивый город, но провинция. Слушай, Немец, мне комнатка нужна маленькая в ',
                                    },
                                },
                                {
                                    type: ETextBlocksType.searchHotelsLinkBlock,
                                    data: {
                                        text: 'центре',
                                        urlParams: {
                                            filterParams: {},
                                        },
                                    },
                                },
                                {
                                    type: ETextBlocksType.plainTextBlock,
                                    data: {
                                        text: ', чтобы тихо было.',
                                    },
                                },
                            ],
                        },
                    ],
                },
                {
                    type: ETextBlocksType.subSectionTextBlock,
                    data: {
                        title: 'Там Шевчук, Кинчев, Настя - все',
                    },
                    children: [
                        {
                            type: ETextBlocksType.textBlock,
                            children: [
                                {
                                    type: ETextBlocksType.plainTextBlock,
                                    data: {
                                        text: 'А это что? - Это ',
                                    },
                                },
                                {
                                    type: ETextBlocksType.externalLinkBlock,
                                    data: {
                                        text: 'Наутилуса ',
                                        url: 'https://ru.wikipedia.org/wiki/Наутилус_(группа)',
                                    },
                                },
                                {
                                    type: ETextBlocksType.plainTextBlock,
                                    data: {
                                        text: 'концерт. Юбилейный. Очень редкий. Я достал.',
                                    },
                                },
                            ],
                        },
                    ],
                },
                {
                    type: ETextBlocksType.subSectionTextBlock,
                    data: {
                        title: 'Выручай, брат!',
                    },
                    children: [
                        {
                            type: ETextBlocksType.textBlock,
                            children: [
                                {
                                    type: ETextBlocksType.plainTextBlock,
                                    data: {
                                        text: 'Надо срочно подъехать и разобраться вместо меня. Да, сразу за ',
                                    },
                                },
                                {
                                    type: ETextBlocksType.hotelLinkBlock,
                                    data: {
                                        text: 'гостиницей "Прибалтийская" ',
                                        urlParams: {
                                            hotelSlug:
                                                'saint-petersburg/park-inn-by-radisson-pribaltiyskaya/',
                                        },
                                    },
                                },
                                {
                                    type: ETextBlocksType.plainTextBlock,
                                    data: {
                                        text: 'на Васильевском, в пять. Будет стоять "Вольво", там двое парней, они всё растолкуют.',
                                    },
                                },
                            ],
                        },
                    ],
                },
            ],
        },
        {
            type: ETextBlocksType.sectionTextBlock,
            data: {
                title: 'А едешь-то куда? В Москву!',
            },
            children: [
                {
                    type: ETextBlocksType.spoilerBlock,
                    data: {
                        title: 'Кто в Москве не бывал',
                        description: {
                            type: ETextBlocksType.textBlock,
                            children: [
                                {
                                    type: ETextBlocksType.plainTextBlock,
                                    data: {
                                        text: 'Красоты не видал.',
                                    },
                                },
                            ],
                        },
                    },
                },
                {
                    type: ETextBlocksType.spoilerBlock,
                    data: {
                        title: 'Ну Татарин!',
                        description: {
                            type: ETextBlocksType.textBlock,
                            children: [
                                {
                                    type: ETextBlocksType.plainTextBlock,
                                    data: {
                                        text: 'Жизнь висит на нитке, а думает о прибытке.',
                                    },
                                },
                            ],
                        },
                    },
                },
                {
                    type: ETextBlocksType.spoilerBlock,
                    data: {
                        title: 'Это был не Татарин, а молодой. Всё классно сделал.',
                        description: {
                            type: ETextBlocksType.textBlock,
                            children: [
                                {
                                    type: ETextBlocksType.plainTextBlock,
                                    data: {
                                        text: 'Профессионал.',
                                    },
                                },
                            ],
                        },
                    },
                },
            ],
        },
        {
            type: ETextBlocksType.sectionTextBlock,
            data: {
                title: 'Ну что могу предложить, господа?',
            },
            children: [
                {
                    type: ETextBlocksType.geoLinkGroupBlock,
                    data: {
                        mainLink: {
                            type: ETextBlocksType.regionLinkBlock,
                            data: {
                                text: 'Тульский Токарев',
                                urlParams: {
                                    regionSlug: 'tokarev',
                                },
                            },
                        },
                        additionalLink: {
                            type: ETextBlocksType.regionLinkBlock,
                            data: {
                                text: 'TT',
                                urlParams: {
                                    regionSlug: 'tt',
                                },
                            },
                        },
                    },
                },
                {
                    type: ETextBlocksType.geoLinkGroupBlock,
                    data: {
                        mainLink: {
                            type: ETextBlocksType.regionLinkBlock,
                            data: {
                                text: 'ППШ',
                                urlParams: {
                                    regionSlug: 'ppsh',
                                },
                            },
                        },
                        additionalLink: {
                            type: ETextBlocksType.regionLinkBlock,
                            data: {
                                text: 'Машина тяжелая, но убойная',
                                urlParams: {
                                    regionSlug: 'ppsh',
                                },
                            },
                        },
                    },
                },
                {
                    type: ETextBlocksType.geoLinkGroupBlock,
                    data: {
                        mainLink: {
                            type: ETextBlocksType.regionLinkBlock,
                            data: {
                                text: 'Гранаты',
                                urlParams: {
                                    regionSlug: 'grenades',
                                },
                            },
                        },
                        additionalLink: {
                            type: ETextBlocksType.regionLinkBlock,
                            data: {
                                text: 'Примерно 50 на 50',
                                urlParams: {
                                    regionSlug: 'grenades',
                                },
                            },
                        },
                    },
                },
                {
                    type: ETextBlocksType.geoLinkGroupBlock,
                    data: {
                        mainLink: {
                            type: ETextBlocksType.regionLinkBlock,
                            data: {
                                text: 'Вальтер',
                                urlParams: {
                                    regionSlug: 'walter',
                                },
                            },
                        },
                        additionalLink: {
                            type: ETextBlocksType.regionLinkBlock,
                            data: {
                                text: 'Импортное',
                                urlParams: {
                                    regionSlug: 'walter',
                                },
                            },
                        },
                    },
                },
                {
                    type: ETextBlocksType.geoLinkGroupBlock,
                    data: {
                        mainLink: {
                            type: ETextBlocksType.regionLinkBlock,
                            data: {
                                text: 'Фауст патроны',
                                urlParams: {
                                    regionSlug: 'faust',
                                },
                            },
                        },
                        additionalLink: {
                            type: ETextBlocksType.regionLinkBlock,
                            data: {
                                text: 'Эхо войны',
                                urlParams: {
                                    regionSlug: 'faust',
                                },
                            },
                        },
                    },
                },
            ],
        },
        {
            type: EGeoRegionBlockType.REGION_LINK_SET_BLOCK,
            data: {
                title: 'Подборки отелей по критериям',
                subsets: [
                    {
                        type: EGeoRegionBlockType.REGION_LINK_SUB_SET_BLOCK,
                        data: {
                            title: 'По звездам',
                            links: [
                                {
                                    type: ETextBlocksType.regionLinkBlock,
                                    data: {
                                        text: '5 звезд',
                                        urlParams: {
                                            regionSlug: 'msk',
                                            filterSlug: 'dds',
                                        },
                                    },
                                },
                                {
                                    type: ETextBlocksType.regionLinkBlock,
                                    data: {
                                        text: '5 звезд в центре',
                                        urlParams: {
                                            regionSlug: 'msk',
                                            filterSlug: 'dds',
                                        },
                                    },
                                },
                                {
                                    type: ETextBlocksType.regionLinkBlock,
                                    data: {
                                        text: 'Хостелы',
                                        urlParams: {
                                            regionSlug: 'msk',
                                            filterSlug: 'dds',
                                        },
                                    },
                                },
                                {
                                    type: ETextBlocksType.regionLinkBlock,
                                    data: {
                                        text: '5 звезд с бассейном',
                                        urlParams: {
                                            regionSlug: 'msk',
                                            filterSlug: 'dds',
                                        },
                                    },
                                },
                                {
                                    type: ETextBlocksType.regionLinkBlock,
                                    data: {
                                        text: 'Койко-места посуточно',
                                        urlParams: {
                                            regionSlug: 'msk',
                                            filterSlug: 'dds',
                                        },
                                    },
                                },
                                {
                                    type: ETextBlocksType.regionLinkBlock,
                                    data: {
                                        text: 'Квартиры посуточно',
                                        urlParams: {
                                            regionSlug: 'msk',
                                            filterSlug: 'dds',
                                        },
                                    },
                                },
                            ],
                        },
                    },
                    {
                        type: EGeoRegionBlockType.REGION_LINK_SUB_SET_BLOCK,
                        data: {
                            title: 'По расположению',
                            links: [
                                {
                                    type: ETextBlocksType.regionLinkBlock,
                                    data: {
                                        text: 'Рядом с вокзалом',
                                        urlParams: {
                                            regionSlug: 'msk',
                                            filterSlug: 'dds',
                                        },
                                    },
                                },
                                {
                                    type: ETextBlocksType.regionLinkBlock,
                                    data: {
                                        text: 'Рядом с центром',
                                        urlParams: {
                                            regionSlug: 'msk',
                                            filterSlug: 'dds',
                                        },
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
    ],
    extraVisitAndUserParams: {},
};

export default geoRegionResponse;
