import {ISearchHotelsInfoResponse} from '../types/ISearchHotels';
import {MainAmenityIdType} from 'types/hotels/hotel/IHotel';
import {ERefundType} from 'types/hotels/offer/IHotelOfferCancellationInfo';
import {
    EBasicFilterGroupType,
    EDetailedFiltersBatchItemType,
    EQuickControlType,
} from 'types/hotels/search/IFiltersInfo';

import {CURRENCY_RUB} from 'utilities/currency/codes';

const searchHotels: ISearchHotelsInfoResponse = {
    context:
        'IDIqMQokM2MxNGI4ZjYtNDUyYi00OGU3LTk5N2UtOWIxZTkzZGU3ZWYyEN2pu5PiLRgAIAE=',
    pollEpoch: 0,
    pollIteration: 0,
    searchPagePollingId: '123456654321',
    navigationTokens: {
        nextPage: 'dfdf',
        currentPage: 'dsdfdf',
        prevPage: 'sdfsdfdsf',
    },
    bboxAsString: '',
    bboxAsStruct: [
        {lat: 55.31184756, lon: 37.04087471},
        {lat: 56.18962338, lon: 38.20413329},
    ],
    actualRegion: {
        name: 'Москва',
    },
    searchRegion: {
        geoId: 213,
        linguistics: {
            ablativeCase: '',
            accusativeCase: 'Москву',
            dativeCase: 'Москве',
            directionalCase: '',
            genitiveCase: 'Москвы',
            instrumentalCase: 'Москвой',
            locativeCase: '',
            nominativeCase: 'Москва',
            preposition: 'в',
            prepositionalCase: 'Москве',
        },
    },
    sortInfo: {
        selectedSortId: undefined,
        availableSortTypeGroups: [],
    },
    foundHotelCount: 0,
    filterInfo: {
        params: {},
        resetFilterInfo: null,
        quickFilters: [
            {
                id: '1',
                name: 'Более 2 звезд',
                enabled: true,
                atomsOn: ['4:star', '3:star'],
                atomsOff: ['2:star'],
                type: EQuickControlType.QUICK_FILTER,
            },
        ],
        detailedFilters: [
            {
                type: EDetailedFiltersBatchItemType.GROUP,
                detailedFilters: {
                    id: '24',
                    name: 'Звездность',
                    type: EBasicFilterGroupType.MULTI,
                    items: [
                        {
                            id: '1',
                            name: '2 звезды',
                            enabled: true,
                            hint: '10',
                            atoms: ['2:star'],
                        },
                        {
                            id: '2',
                            name: '3 звезды',
                            enabled: true,
                            hint: '20',
                            atoms: ['3:star'],
                        },
                        {
                            id: '3',
                            name: '4 звезды',
                            enabled: true,
                            hint: '50',
                            atoms: ['4:star'],
                        },
                    ],
                },
            },
            {
                type: EDetailedFiltersBatchItemType.GROUP,
                detailedFilters: {
                    id: '13213',
                    name: 'Рейтинг',
                    type: EBasicFilterGroupType.MULTI,
                    items: [
                        {
                            id: '23',
                            name: '1 и выше',
                            enabled: true,
                            hint: '10',
                            atoms: ['1:rating'],
                        },
                        {
                            id: '1323',
                            name: '2 и выше',
                            enabled: true,
                            hint: '20',
                            atoms: ['2:rating'],
                        },
                        {
                            id: '123123',
                            name: '3 и выше',
                            enabled: true,
                            hint: '50',
                            atoms: ['3:rating'],
                        },
                        {
                            id: '23243',
                            name: '4 и выше',
                            enabled: true,
                            hint: '60',
                            atoms: ['4:rating'],
                        },
                    ],
                },
            },
        ],
        detailedFiltersBatches: [
            {
                items: [
                    {
                        type: EDetailedFiltersBatchItemType.GROUP,
                        detailedFilters: {
                            id: '24',
                            name: 'Звездность',
                            type: EBasicFilterGroupType.MULTI,
                            items: [
                                {
                                    id: '1',
                                    name: '2 звезды',
                                    enabled: true,
                                    hint: '10',
                                    atoms: ['2:star'],
                                },
                                {
                                    id: '2',
                                    name: '3 звезды',
                                    enabled: true,
                                    hint: '20',
                                    atoms: ['3:star'],
                                },
                                {
                                    id: '3',
                                    name: '4 звезды',
                                    enabled: true,
                                    hint: '50',
                                    atoms: ['4:star'],
                                },
                            ],
                        },
                    },
                    {
                        type: EDetailedFiltersBatchItemType.GROUP,
                        detailedFilters: {
                            id: '13213',
                            name: 'Рейтинг',
                            type: EBasicFilterGroupType.MULTI,
                            items: [
                                {
                                    id: '23',
                                    name: '1 и выше',
                                    enabled: true,
                                    hint: '10',
                                    atoms: ['1:rating'],
                                },
                                {
                                    id: '1323',
                                    name: '2 и выше',
                                    enabled: true,
                                    hint: '20',
                                    atoms: ['2:rating'],
                                },
                                {
                                    id: '123123',
                                    name: '3 и выше',
                                    enabled: true,
                                    hint: '50',
                                    atoms: ['3:rating'],
                                },
                                {
                                    id: '23243',
                                    name: '4 и выше',
                                    enabled: true,
                                    hint: '60',
                                    atoms: ['4:rating'],
                                },
                            ],
                        },
                    },
                ],
            },
        ],
        priceFilter: {
            minPriceEstimate: 0,
            maxPriceEstimate: 10000,
            currency: CURRENCY_RUB,
        },
        geoIdFilter: null,
    },
    searchControlInfo: {
        quickControls: [
            {
                id: '1',
                name: 'Более 2 звезд',
                enabled: true,
                atomsOn: ['4:star', '3:star'],
                atomsOff: ['2:star'],
                type: EQuickControlType.QUICK_FILTER,
            },
        ],
    },
    offerSearchParams: {
        checkinDate: '2019-11-14',
        checkoutDate: '2019-11-15',
        adults: 2,
        childrenAges: [10, 12],
    },
    offerSearchProgress: {
        finished: true,
        partnersTotal: 5,
        partnersComplete: 5,
    },
    pricedHotelCount: 50,
    hotels: [
        {
            hotel: {
                permalink: '1019057204',
                hotelSlug: 'fdsf/sdfds',
                name: 'Marriott Grand Hotel',
                category: {id: 'hotels', name: 'Гостиница'},
                coordinates: {
                    lat: 55.768322,
                    lon: 37.599392,
                },
                address: 'Россия, Москва, Тверская улица, 26/1',
                stars: 5,
                rating: 5,
                totalTextReviewCount: 315,
                totalImageCount: 139,
                images: [
                    {
                        urlTemplate:
                            'https://avatars.mds.yandex.net/get-altay/492546/2a0000015fdc1509311f2ce61d539f0187e4/%s',
                        id: 'urn:yandex:sprav:photo:7805558',
                        sizes: [
                            {
                                size: 'XXXS',
                                height: 32,
                                width: 50,
                            },
                            {
                                size: 'XXS',
                                height: 48,
                                width: 75,
                            },
                            {
                                size: 'XS',
                                height: 64,
                                width: 100,
                            },
                            {size: 'S', height: 96, width: 150},
                            {
                                size: 'M',
                                height: 192,
                                width: 300,
                            },
                            {size: 'L', height: 319, width: 500},
                            {
                                size: 'XL',
                                height: 511,
                                width: 800,
                            },
                            {size: 'XXL', height: 511, width: 800},
                            {
                                size: 'XXXL',
                                height: 511,
                                width: 800,
                            },
                            {size: 'orig', height: 511, width: 800},
                        ],
                        tags: ['Interior'],
                    },
                ],
                mainAmenities: [
                    {
                        id: MainAmenityIdType.WI_FI,
                        name: 'Модем',
                    },
                    {
                        id: MainAmenityIdType.POOL,
                        name: 'Можно пьяным в бассейн',
                    },
                    {
                        id: MainAmenityIdType.CAR_PARK,
                        name: 'Парковка',
                    },
                    {
                        id: MainAmenityIdType.AIR_CONDITIONING,
                        name: 'Прохладно там где надо',
                    },
                    {
                        id: MainAmenityIdType.GYM,
                        name: 'На спортике',
                    },
                    {
                        id: MainAmenityIdType.PAYMENT_BY_CARD,
                        name: 'Оплата картой',
                    },
                    {
                        id: MainAmenityIdType.BEACH_LINE,
                        name: 'Ещё и пляж недалеко',
                    },
                ],
                isFavorite: false,
            },
            searchIsFinished: true,
            searchedByUser: false,
            offers: [
                {
                    id: '105c9769-ebee-498e-822e-605972a17ba7',
                    name: 'Сгенерированный номер 1',
                    price: {value: 5802, currency: CURRENCY_RUB},
                    operatorId: '2',
                    landingUrl:
                        'http://travel-redir-test.n.yandex-team.ru/redir?PUrl=3Gr1wFS-wChW4f4FwJNJ-kZpeCavkH0NC_WdX21qWh8sDBusVxnSOBXFLlETl3iFAF9XTkJLiF7J6mwlmtk2Ndw69CwhcnlRf7QyLQTLNy5K45X1gJxojME_7YzD_LLimS6skHX6yQ6nS6DKHyUbh-eMBCqU2BCYiwGFfx-wlE7ijDLfgesBGOl6-NbKuwxwuE-AjRbFqVBCxlPsYVAq95aJWetzZJU90TovyJzaSGUsZuLutJq1gWJuBRrwqVzuSHgfLJWsZuOikmDD&ProtoLabel=CgRzZXJwEgxib29raW5nX2Zvcm0iC2Z1bGxfb2ZmZXJzSAJSCtC-0YLQtdC70LhaJTE1NzI1MzU3MTkxNjM4NjYtMjAwMzA3NjMxNy12bGExLTE1MDdgqi1w6vrr7QV4tKj25QOCASQxMDVjOTc2OS1lYmVlLTQ5OGUtODIyZS02MDU5NzJhMTdiYTeKASM4Zjc5MWFkNi1jODBkMzhmZi01ODgxZjY2Ny0xMDBjZjNlM5IBBHNlcnCiAQU0MDk5NrgBAsIBCjIwMTktMTEtMTTIAQHSAQcyLTEwLDEy4AHVAegB1QH6AQ10cmF2ZWwucG9ydGFsggIddHJhdmVsLXBvcnRhbC1tdWx0aWhvdGVsLXBhZ2V7',
                    cancellationInfo: {
                        hasFreeCancellation: true,
                        refundType: ERefundType.FULLY_REFUNDABLE,
                    },
                    mealType: {id: 'RO', name: 'Включено все'},
                },
                {
                    id: '105c9769-ebee-498e-822e-605972a17ba7',
                    name: 'Сгенерированный номер 1',
                    price: {value: 32, currency: CURRENCY_RUB},
                    operatorId: '2',
                    landingUrl:
                        'http://travel-redir-test.n.yandex-team.ru/redir?PUrl=3Gr1wFS-wChW4f4FwJNJ-kZpeCavkH0NC_WdX21qWh8sDBusVxnSOBXFLlETl3iFAF9XTkJLiF7J6mwlmtk2Ndw69CwhcnlRf7QyLQTLNy5K45X1gJxojME_7YzD_LLimS6skHX6yQ6nS6DKHyUbh-eMBCqU2BCYiwGFfx-wlE7ijDLfgesBGOl6-NbKuwxwuE-AjRbFqVBCxlPsYVAq95aJWetzZJU90TovyJzaSGUsZuLutJq1gWJuBRrwqVzuSHgfLJWsZuOikmDD&ProtoLabel=CgRzZXJwEgxib29raW5nX2Zvcm0iC2Z1bGxfb2ZmZXJzSAJSCtC-0YLQtdC70LhaJTE1NzI1MzU3MTkxNjM4NjYtMjAwMzA3NjMxNy12bGExLTE1MDdgqi1w6vrr7QV4tKj25QOCASQxMDVjOTc2OS1lYmVlLTQ5OGUtODIyZS02MDU5NzJhMTdiYTeKASM4Zjc5MWFkNi1jODBkMzhmZi01ODgxZjY2Ny0xMDBjZjNlM5IBBHNlcnCiAQU0MDk5NrgBAsIBCjIwMTktMTEtMTTIAQHSAQcyLTEwLDEy4AHVAegB1QH6AQ10cmF2ZWwucG9ydGFsggIddHJhdmVsLXBvcnRhbC1tdWx0aWhvdGVsLXBhZ2V7',
                    cancellationInfo: {
                        hasFreeCancellation: false,
                        refundType: ERefundType.NON_REFUNDABLE,
                    },
                    mealType: {id: 'RO', name: 'Без питания'},
                },
                {
                    id: '105c9769-ebee-498e-822e-605972a17ba7',
                    name: 'Сгенерированный номер 1',
                    price: {value: 23444, currency: CURRENCY_RUB},
                    operatorId: '2',
                    landingUrl:
                        'http://travel-redir-test.n.yandex-team.ru/redir?PUrl=3Gr1wFS-wChW4f4FwJNJ-kZpeCavkH0NC_WdX21qWh8sDBusVxnSOBXFLlETl3iFAF9XTkJLiF7J6mwlmtk2Ndw69CwhcnlRf7QyLQTLNy5K45X1gJxojME_7YzD_LLimS6skHX6yQ6nS6DKHyUbh-eMBCqU2BCYiwGFfx-wlE7ijDLfgesBGOl6-NbKuwxwuE-AjRbFqVBCxlPsYVAq95aJWetzZJU90TovyJzaSGUsZuLutJq1gWJuBRrwqVzuSHgfLJWsZuOikmDD&ProtoLabel=CgRzZXJwEgxib29raW5nX2Zvcm0iC2Z1bGxfb2ZmZXJzSAJSCtC-0YLQtdC70LhaJTE1NzI1MzU3MTkxNjM4NjYtMjAwMzA3NjMxNy12bGExLTE1MDdgqi1w6vrr7QV4tKj25QOCASQxMDVjOTc2OS1lYmVlLTQ5OGUtODIyZS02MDU5NzJhMTdiYTeKASM4Zjc5MWFkNi1jODBkMzhmZi01ODgxZjY2Ny0xMDBjZjNlM5IBBHNlcnCiAQU0MDk5NrgBAsIBCjIwMTktMTEtMTTIAQHSAQcyLTEwLDEy4AHVAegB1QH6AQ10cmF2ZWwucG9ydGFsggIddHJhdmVsLXBvcnRhbC1tdWx0aWhvdGVsLXBhZ2V7',
                    cancellationInfo: {
                        hasFreeCancellation: false,
                        refundType: ERefundType.NON_REFUNDABLE,
                    },
                    mealType: {id: 'RO', name: 'Без питания'},
                },
                {
                    id: '105c9769-ebee-498e-822e-605972a17ba7',
                    name: 'Сгенерированный номер 1',
                    price: {value: 2222, currency: CURRENCY_RUB},
                    operatorId: '2',
                    landingUrl:
                        'http://travel-redir-test.n.yandex-team.ru/redir?PUrl=3Gr1wFS-wChW4f4FwJNJ-kZpeCavkH0NC_WdX21qWh8sDBusVxnSOBXFLlETl3iFAF9XTkJLiF7J6mwlmtk2Ndw69CwhcnlRf7QyLQTLNy5K45X1gJxojME_7YzD_LLimS6skHX6yQ6nS6DKHyUbh-eMBCqU2BCYiwGFfx-wlE7ijDLfgesBGOl6-NbKuwxwuE-AjRbFqVBCxlPsYVAq95aJWetzZJU90TovyJzaSGUsZuLutJq1gWJuBRrwqVzuSHgfLJWsZuOikmDD&ProtoLabel=CgRzZXJwEgxib29raW5nX2Zvcm0iC2Z1bGxfb2ZmZXJzSAJSCtC-0YLQtdC70LhaJTE1NzI1MzU3MTkxNjM4NjYtMjAwMzA3NjMxNy12bGExLTE1MDdgqi1w6vrr7QV4tKj25QOCASQxMDVjOTc2OS1lYmVlLTQ5OGUtODIyZS02MDU5NzJhMTdiYTeKASM4Zjc5MWFkNi1jODBkMzhmZi01ODgxZjY2Ny0xMDBjZjNlM5IBBHNlcnCiAQU0MDk5NrgBAsIBCjIwMTktMTEtMTTIAQHSAQcyLTEwLDEy4AHVAegB1QH6AQ10cmF2ZWwucG9ydGFsggIddHJhdmVsLXBvcnRhbC1tdWx0aWhvdGVsLXBhZ2V7',
                    cancellationInfo: {
                        hasFreeCancellation: false,
                        refundType: ERefundType.NON_REFUNDABLE,
                    },
                    mealType: {id: 'RO', name: 'Без питания'},
                },
                {
                    id: '105c9769-ebee-498e-822e-605972a17ba7',
                    name: 'Сгенерированный номер 1',
                    price: {value: 2222, currency: CURRENCY_RUB},
                    operatorId: '2',
                    landingUrl:
                        'http://travel-redir-test.n.yandex-team.ru/redir?PUrl=3Gr1wFS-wChW4f4FwJNJ-kZpeCavkH0NC_WdX21qWh8sDBusVxnSOBXFLlETl3iFAF9XTkJLiF7J6mwlmtk2Ndw69CwhcnlRf7QyLQTLNy5K45X1gJxojME_7YzD_LLimS6skHX6yQ6nS6DKHyUbh-eMBCqU2BCYiwGFfx-wlE7ijDLfgesBGOl6-NbKuwxwuE-AjRbFqVBCxlPsYVAq95aJWetzZJU90TovyJzaSGUsZuLutJq1gWJuBRrwqVzuSHgfLJWsZuOikmDD&ProtoLabel=CgRzZXJwEgxib29raW5nX2Zvcm0iC2Z1bGxfb2ZmZXJzSAJSCtC-0YLQtdC70LhaJTE1NzI1MzU3MTkxNjM4NjYtMjAwMzA3NjMxNy12bGExLTE1MDdgqi1w6vrr7QV4tKj25QOCASQxMDVjOTc2OS1lYmVlLTQ5OGUtODIyZS02MDU5NzJhMTdiYTeKASM4Zjc5MWFkNi1jODBkMzhmZi01ODgxZjY2Ny0xMDBjZjNlM5IBBHNlcnCiAQU0MDk5NrgBAsIBCjIwMTktMTEtMTTIAQHSAQcyLTEwLDEy4AHVAegB1QH6AQ10cmF2ZWwucG9ydGFsggIddHJhdmVsLXBvcnRhbC1tdWx0aWhvdGVsLXBhZ2V7',
                    cancellationInfo: {
                        hasFreeCancellation: false,
                        refundType: ERefundType.NON_REFUNDABLE,
                    },
                    mealType: {id: 'RO', name: 'Без питания'},
                },
            ],
        },
    ],
    operatorById: {
        '2': {
            id: '2',
            name: 'Booking.com',
            greenUrl: 'booking.com',
            iconUrl: 'https://yastatic.net/s3/travel-indexer/icons/booking.svg',
        },
        '4': {
            id: '4',
            name: 'Ostrovok.ru',
            greenUrl: 'ostrovok.ru',
            iconUrl:
                'https://yastatic.net/s3/travel-indexer/icons/ostrovok.svg',
        },
        '18': {
            id: '18',
            name: 'Hotels.com',
            greenUrl: 'hotels.com',
            iconUrl:
                'https://yastatic.net/s3/travel-indexer/icons/hotelscom.svg',
        },
        '20': {
            id: '20',
            name: 'Hotel.info',
            greenUrl: 'hotel.info',
            iconUrl:
                'https://yastatic.net/s3/travel-indexer/icons/hotelsinfo.svg',
        },
        '21': {
            id: '21',
            name: 'Agoda.com',
            greenUrl: 'agoda.com',
            iconUrl: 'https://yastatic.net/s3/travel-indexer/icons/agoda.svg',
        },
        '40': {
            id: '40',
            name: 'Яндекс.Путешествия',
            greenUrl: 'travel.yandex.ru',
            iconUrl: 'https://yastatic.net/s3/travel-indexer/icons/travel.svg',
        },
    },
    extraVisitAndUserParams: {},
    timingInfo: {currentRequestDurationMs: 1000},
    hasBoyOffers: true,
};

export default searchHotels;
