import {
    IDebugOfferSearchParams,
    IRequiredOfferParams,
} from 'types/hotels/offer/IHotelOffer';
import {
    IFilterParams,
    IFiltersInfo,
    ISearchControlsInfo,
} from 'types/hotels/search/IFiltersInfo';
import {MapBoundsAsStringType} from 'types/common/ICoordinates';

import {IBaseErrorResponse} from 'server/controllers/hotelsApiController/HotelsBaseController';

/* 1. RequestParams */

export interface ICountHotelsRequestParams
    extends Partial<IRequiredOfferParams>,
        IFilterParams,
        Partial<IDebugOfferSearchParams> {
    bbox?: MapBoundsAsStringType;
}

/* 2. SuccessResponse */

export interface ICountHotelsResponse extends ICountHotels {}

export interface ICountHotels {
    foundHotelCount: number;
    filterInfo: IFiltersInfo;
    searchControlInfo: ISearchControlsInfo;
}

/* 3. ErrorResponse */

export interface ICountHotelsError extends IBaseErrorResponse {}
