export interface IResetFilterInfo {
    // Список возможных действий для сброса фильтров
    actions: IResetFilterAction[];
    // Причина, по которой нужен сброс фильтрации
    resetFilterReason: EResetFilterReason;
}

export interface IResetFilterAction {
    // Название действия
    name: string;
    // Тип визуального отображения
    effect: EResetFilterActionEffect;
    // Список id атомов фильтрации, которые нужно выключить при выборе текущего действия
    atomsOff: string[];
    // Значения фильтров по цене после выбора текущего действия
    needResetFilterPrice: boolean;
    // Нужно ли сбрасывать фильтр по geo id. Если true - выставить значение фильтра false, если false - не изменять значения фильтра
    needResetGeoIdFilter: boolean;
}

export enum EResetFilterActionEffect {
    ALL = 'reset:all',
    SIMPLE = 'reset:simple',
}

export enum EResetFilterReason {
    ZOOMING_MAP = 'zooming_map',
    FILTERS = 'filters',
}
