import {IHotelsAttributionParams} from 'types/hotels/common/IAttribution';
import {
    IRequiredOfferParams,
    IHotelOfferSearchProgress,
    IDebugOfferSearchParams,
} from 'types/hotels/offer/IHotelOffer';
import {
    IFilterParams,
    IFiltersInfo,
    ISearchControlsInfo,
} from 'types/hotels/search/IFiltersInfo';
import {ISortParams, ISortInfo} from 'types/hotels/search/ISortInfo';
import {INavigationTokens} from 'types/hotels/search/INavigationTokens';
import {MapBoundsType} from 'types/common/ICoordinates';
import {GeoIdType, IGeoRegion} from 'types/hotels/hotel/IGeoRegion';
import {IHotelWithOffers} from 'types/hotels/hotel/IHotelWithOffers';
import {OperatorByIdType} from 'types/hotels/offer/IHotelsOperator';
import {IActualGeoRegion} from 'types/hotels/hotel/IActualGeoRegion';
import {EStartSearchReason} from 'types/hotels/search/ISearchReason';
import {IExtraVisitAndUserParams} from 'types/hotels/common/IExtraVisitAndUserParams';
import ITimingInfo from 'types/hotels/common/ITimingInfo';
import {HotelSlugType} from 'types/hotels/hotel/IHotel';

import {ESearchBanner} from 'reducers/hotels/searchPage/search/reducer';

import {IBaseErrorResponse} from 'server/controllers/hotelsApiController/HotelsBaseController';

/* 1. RequestParams */

export interface ISearchHotelsInfoRequestParams
    extends IHotelsAttributionParams,
        IRequiredOfferParams,
        Partial<IDebugOfferSearchParams>,
        IFilterParams,
        ISortParams {
    domain: string;
    context?: string;
    navigationToken?: string;
    geoId?: GeoIdType;
    bbox?: string;
    pageHotelCount: number;
    pricedHotelLimit: number;
    totalHotelLimit: number;
    pollEpoch: number;
    pollIteration: number;
    startSearchReason: EStartSearchReason;
    topHotelSlug?: HotelSlugType;
}

/* 2. SuccessResponse */

export interface ISearchHotelsInfoResponse extends ISearchHotelsInfo {}

export interface ISearchHotelsInfo {
    context: string;
    pollEpoch: number;
    pollIteration: number;
    /**
     * SearchPagePollingId
     * id итерации поиска на портале
     * он должен браться из урла и прозрачно пробрасываться на бек.
     */
    searchPagePollingId?: string;
    navigationTokens: INavigationTokens;
    bboxAsString: string;
    bboxAsStruct: MapBoundsType;
    actualRegion: IActualGeoRegion;
    searchRegion: IGeoRegion;
    foundHotelCount: number;
    pricedHotelCount: number;
    filterInfo: IFiltersInfo;
    searchControlInfo: ISearchControlsInfo;
    sortInfo: ISortInfo;
    offerSearchParams: IRequiredOfferParams;
    offerSearchProgress: IHotelOfferSearchProgress;
    hotels: IHotelWithOffers[];
    operatorById: OperatorByIdType;
    searchBannerType?: ESearchBanner;
    extraVisitAndUserParams: IExtraVisitAndUserParams;
    topHotelSlug?: HotelSlugType; // Параметр для выделения выбранного отеля в поиске
    timingInfo: ITimingInfo; // Время обработки текущего запроса бекендом
    nextPollingRequestDelayMs?: number; // Заполнено, если offerSearchProgress.finished == false
    hasBoyOffers: boolean;
}

/* 3. ErrorResponse */

export interface ISearchHotelsInfoError extends IBaseErrorResponse {}
