import {GeoIdType} from 'types/hotels/hotel/IGeoRegion';
import {IHotelIdentifier} from 'types/hotels/hotel/IHotel';
import {
    TSuggestGroups,
    TSuggestItems,
} from 'types/hotels/common/ISearchSuggest';
import {TGeoRegionSlug} from 'types/hotels/geoRegion/IGeoRegionInfo';
import {EGeoLocationStatus} from 'types/common/browserGeolocation';

import {IBaseErrorResponse} from 'server/controllers/hotelsApiController/HotelsBaseController';

/* 1. RequestParams */

export interface ISearchSuggestRequestParams extends IHotelIdentifier {
    query?: string;
    geoId?: GeoIdType;
    limit: number;
    language: string;
    domain: string;
    regionSlug?: TGeoRegionSlug;
    sessionId: string;
    requestIndex: number;
    pathname: string;
    geoLocationStatus?: EGeoLocationStatus;
    userCoordinates?: string;
}

/* 2. SuccessResponse */

export interface ISearchSuggestGroupsResponse {
    groups: TSuggestGroups;
}

export interface ISearchSuggestResponse {
    items: TSuggestItems;
}

/* 3. ErrorResponse */

export interface ISearchSuggestError extends IBaseErrorResponse {}
