import _get from 'lodash/get';

import {StatusCodes} from '../constants/statusCodes';

/* Types */
import {ISearchHotelsInfoError} from '../types/ISearchHotels';

export const prepareSearchHotelsError = (
    apiError: any,
): ISearchHotelsInfoError => {
    const responseStatusCode = _get(apiError, 'response.status');

    return {
        statusCode:
            responseStatusCode || StatusCodes.UNKNOWN_SEARCH_ERROR_STATUS_CODE,
    };
};
