import _get from 'lodash/get';
import _flatMap from 'lodash/flatMap';

import {StatusCodes} from '../constants/statusCodes';

import {
    ISearchSuggestError,
    ISearchSuggestResponse,
    ISearchSuggestGroupsResponse,
} from '../types/ISearchSuggest';
import {
    ISuggestGroup,
    IHotelsSuggest,
} from 'types/hotels/common/ISearchSuggest';

const flatSuggestGroup = (group: ISuggestGroup): IHotelsSuggest[] => {
    const {name: groupName, items} = group;

    return items.map(
        (item): IHotelsSuggest => ({
            ...item,
            groupName,
        }),
    );
};

export const prepareSearchSuggest = (
    payload: ISearchSuggestGroupsResponse,
): ISearchSuggestResponse => {
    const groups = payload?.groups;

    return {
        items: _flatMap(groups, flatSuggestGroup),
    };
};

export const prepareSearchSuggestError = (
    apiError: any,
): ISearchSuggestError => {
    const responseStatusCode = _get(apiError, 'response.status');

    return {
        statusCode:
            responseStatusCode || StatusCodes.UNKNOWN_SEARCH_ERROR_STATUS_CODE,
    };
};
