import {Readable} from 'stream';
import axios from 'axios';

import {IGenerateImageQuery} from './types';
import {EApiEntry} from 'types/EApiEntry';

import {RestApiClient} from 'server/utilities/RestApiClient';

import {IDependencies} from 'server/getContainerConfig';

export type {IGenerateImageQuery};
export class ImageGeneratorApi extends RestApiClient {
    constructor({
        logger,
        requestId,
        getApiHost,
        getSrcParams,
        httpClient,
        sendClickHouseStats,
        rootSpan,
    }: IDependencies) {
        super({
            baseURL: getApiHost(EApiEntry.IMAGE_GENERATOR),
            logger,
            requestId,
            httpClient,
            sendClickHouseStats,
            rootSpan,
        });

        this.srcParams = getSrcParams(EApiEntry.IMAGE_GENERATOR);
    }

    generate = async (query: IGenerateImageQuery): Promise<Readable> => {
        const url = axios.getUri({
            url: `${this.baseURL}/generate`,
            params: query,
        });

        const {data} = await this.httpClient.request<Readable>({
            url,
            method: 'GET',
            responseType: 'stream',
            maxRedirects: 0,
        });

        return data;
    };

    ping = async (): Promise<string> => {
        return this.get('/ping');
    };
}
