// AvailableCountries
export interface IGetAvailableCountriesParams {
    city_from: string;
}

export type TGetAvailableCountriesResponse = string[]; // ["AT", "BG", "HU", "NO", ...]

// Redirect
export interface IGetRedirectParams {
    host: string;
    hotel_ids?: string; //3213123
    from_city: string; //Yekaterinburg
    from_country?: string; //RU
    to_country: string; //TH
    to_city?: string; //Krasnaya Polyana
    nights: string | number; //8
    flex_nights: boolean;
    start_date: string; //11.03.2022
    adults: string | number; //3
    kids?: string | number; //3
    kids_ages?: (string | number)[]; // 2,8,13
    flex_dates: boolean;
    redirect?: boolean;
}

export interface IGetRedirectResponse {
    redirect_url: string; //Moscow-RU-to-Any-AE-departure-18.03.2022-for-5-nights-1-adults-0-kids-1..5-stars?aflt=Ya
    search_params: unknown; // внутри кажется все параметры которые можно настроить в парамсах, но пока смысла использовать нету, поэтому unknown
}

// Flights and nights
export interface IGetFlightsAndNightsParams {
    city_from: string; //Yekaterinburg
    country_to: string; //TH
    start_date: string; //05.03.2022
    end_date: string; //04.03.2023
}
export interface IGetFlightsAndNightsResponse {
    //{2022-04-05: [2, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15]}
    [date: string]: number[];
}

// Autocomplete
export interface IAutocompleteParams {
    query: string;
    from_city: string;
}

export type TAutocompleteResponse = string[]; //"995|Таиланд|Thailand|country|TH|Таиланд|Thailand||1|368528||Без визы|3.5462132"

// Countries
export interface IGetCountriesParams {
    from_city: string;
}

export interface IGetCountriesResponse extends Array<ICountry> {}

export interface ICountry {
    active: boolean; //true
    budget: number; //1
    closed: boolean; //false
    id: number; //1056
    image: string; // "https://s3.level.travel/seo_images/EG/small_widget_2438ffa9e2974db517240328be8dd06b.jpg"
    iso2: string; //"EG"
    name_en: string; // "Egypt"
    name_ru: string; //"Египет"
    passport_format: string; //"99 9999999"
    priority: number; //10
    slt_id: number | null; //null
    visa_type_info: {
        visa_type_id: number; //2;
        visa_type: string; //'on_arrival';
        visa_type_ru: string; //'По прилете';
    };
    visa_type: string; //"on_arrival"
    visa_type_id: number; //2
    visa_type_ru: string; //"По прилете"
}

// Departures
export interface IGetDeparturesParams {
    prioritized_count?: number;
}

export interface IGetDeparturesResponse {
    departures: TDeparture[];
    prioritized_count: number;
    success: boolean;
}

export type TDeparture = {
    //не типизирую airports так как пока не используем, LT типизацию не поставляют, и плохо фиксируют в доке
    airports?: [];
    iata: string; //"MOW" | ""
    id?: number; //213
    iso2: string; //"RU"
    name_en: string; //"Moscow"
    name_ru: string; //"Москва"
    name_ru_form1?: string; // "Москву"
    name_ru_form2?: string; //"Москвы"
    prioritized?: boolean; //true
    priority?: number; //14
};
