import {INotebookDocument} from 'server/api/NotebookApi/types/models';

export interface INotebookCreatePassengerDocumentParams
    extends Pick<INotebookDocument, 'type' | 'number' | 'citizenship'>,
        Partial<
            Pick<
                INotebookDocument,
                | 'title'
                | 'firstName'
                | 'middleName'
                | 'lastName'
                | 'firstNameEn'
                | 'middleNameEn'
                | 'lastNameEn'
                | 'issueDate'
                | 'expirationDate'
            >
        > {}

export interface INotebookCreatePassengerDocumentApiParams {
    uid: string;
    passengerId: string;
    document: INotebookCreatePassengerDocumentParams;
}

export type TNotebookCreatePassengerDocumentApiResponse = INotebookDocument;
