import {INotebookDocument} from 'server/api/NotebookApi/types/models';

export interface INotebookEditPassengerDocumentParams
    extends Pick<
            INotebookDocument,
            'type' | 'title' | 'number' | 'citizenship'
        >,
        Partial<
            Pick<
                INotebookDocument,
                | 'firstName'
                | 'middleName'
                | 'lastName'
                | 'firstNameEn'
                | 'middleNameEn'
                | 'lastNameEn'
                | 'issueDate'
                | 'expirationDate'
            >
        > {}

export interface INotebookEditPassengerDocumentApiParams {
    uid: string;
    passengerId: string;
    documentId: string;
    document: INotebookEditPassengerDocumentParams;
}

export type TNotebookEditPassengerDocumentApiResponse = INotebookDocument;
