import {EGender} from 'types/common/document/EGender';

import {EDocumentType} from 'server/api/TravelersApi/enums/EDocumentType';

export enum ENotebookBonusCard {
    UNIVERSAL_ROAD = 'universal_road',
    RZD_BONUS = 'rzd_bonus',
    AVIA_COMPANY_LOYALTY = 'avia_company_loyalty',
}

export interface INotebookBonusCard {
    id: string;
    number: string;
    passengerId: string;
    title: string;
    type: ENotebookBonusCard;
    createdAt: string;
    updatedAt: string;
}

export interface INotebookDocument {
    id: string;
    citizenship: number;
    firstName: string | null;
    firstNameEn: string | null;
    lastName: string | null;
    lastNameEn: string | null;
    middleName: string | null;
    middleNameEn: string | null;
    /**
     * Дата выпуска документа
     */
    issueDate: string | null;
    expirationDate: null | string;
    number: string;
    passengerId: string;
    title: string;
    type: EDocumentType;
    createdAt: string;
    updatedAt: string;
}

export interface INotebookPassenger {
    id: string;
    birthDate: string;
    bonusCards?: INotebookBonusCard[];
    documents?: INotebookDocument[];
    email: string | null;
    gender: EGender;
    itn: null;
    phone: string | null;
    phoneAdditional: string | null;
    title: string;
    trainNotificationsEnabled: boolean;
    createdAt: string;
    updatedAt: string;
}

export interface INotebookTraveler {
    /**
     * Лицензионное соглашение
     */
    agree: boolean;
    email: string;
    passengers?: INotebookPassenger[];
    phone: string;
    phoneAdditional: string | null;
    createdAt: string;
    updatedAt: string;
}
