import {TLocalDateTimeType} from 'types/common/date/IDate';
import {EAviaOrderDisplayState} from 'types/avia/book/IAviaOrder';
import {ITermValue} from 'server/api/AviaBookingApi/types/ITermValue';
import {TBookingPromoCampaigns} from 'server/api/AviaBookingApi/types/IBookingVariantsResponse';

import IPrice from 'utilities/currency/PriceInterface';

import {ClassOfService} from 'server/api/AviaBookingApi/enums/classOfService';

export interface IAviaOrderResponse {
    id: string;
    prettyId: string;
    partner: string;
    variantId: string;
    email: string;
    phone: string;
    airReservation: IAviaOrderReservation;
    travellers: IAviaOrderTraveller[];
    preliminaryPrice: IPrice;
    price: IPrice;
    agencyMarkup?: IPrice;
    state: EAviaOrderState;
    timeLimitAt: TLocalDateTimeType;
    fareRulesUrl?: string;
    errorCode?: EAviaOrderError;
    orderToken?: string;
    reference: IAviaOrderReference;
    edisplayOrderState: EAviaOrderDisplayState;
    servicedAt: TLocalDateTimeType;
    /** Показываем ли баннер Яндекс.Плюса (промокод плюса отправлен вам на e-mail) */
    promoCampaigns?: TBookingPromoCampaigns;
}

export interface IAviaOrderReservation {
    pnr: string;
    partnerRef?: string;
    segments: IAviaOrderReservationSegment[];
    originalPnr: string;
}

export interface IAviaOrderReservationSegment {
    flights: IAviaOrderReservationSegmentFlight[];
}

export interface IAviaOrderReservationSegmentFlight {
    id: string;
    from: number;
    to: number;
    marketingAviaCompany: number;
    operatingAviaCompany: number;
    number: string;
    arrival: TLocalDateTimeType;
    departure: TLocalDateTimeType;
    stops: IAviaOrderReservationSegmentFlightStop[] | null;
    fareTerms: IAviaOrderReservationSegmentFlightFareTerm;
    seatsLeft?: number;
    aircraftSeats: IAviaOrderReservationSegmentFlightSeatsInfo;
}

export interface IAviaOrderReservationSegmentFlightStop {
    airportId: number;
    terminal: string;
}

export interface IAviaOrderReservationSegmentFlightFareTerm {
    baseClass: ClassOfService;
    tariffGroupName: string;
    terms: Record<string, ITermValue>;
}

export interface IAviaOrderReservationSegmentFlightSeatsInfo {
    total?: number;
    economy?: number;
    comfort?: number;
    business?: number;
    first?: number;
}

export interface IAviaOrderTraveller {
    id: string;
    firstName: string;
    middleName: string;
    lastName: string;
    sex: EAviaOrderTravellerSex;
    category: EAviaOrderTravellerPassengerCategory;
    dateOfBirth: string;
    documentNumber: string;
    documentValidTill: string;
    documentType: EAviaOrderTravellerDocumentType;
    priceInfo: IAviaOrderTravellerPriceInfo;
    ticketNumber?: string;
}

export enum EAviaOrderTravellerSex {
    MALE = 'male',
    FEMALE = 'female',
}

export enum EAviaOrderTravellerPassengerCategory {
    ADULT = 'adult',
    CHILD = 'child',
    INFANT = 'infant',
}

export enum EAviaOrderTravellerDocumentType {
    PASSPORT = 'passport',
    INTERNATIONAL_PASSPORT_RU = 'internation_passport_ru',
    BIRTH_CERTIFICATE = 'birth_certificate',
    NATIONAL_PASSPORT = 'national_passport',
}

export interface IAviaOrderTravellerPriceInfo {
    fare: IPrice;
    tax: IPrice;
    total: IPrice;
}

export enum EAviaOrderState {
    NEW = 'new',
    BOOKING = 'booking',
    BOOKED = 'booked',
    PROCESSING_ERROR = 'processing_error',
    TICKETED = 'ticketed',
    UNRECOGNIZED = 'unrecognized',
}

export enum EAviaOrderError {
    VARIANTS_NOT_AVAILABLE = 'variants_not_available',
    PRICE_CHANGED = 'price_changed',
    PAYMENT_FAILED = 'payment_failed',
    TOKENIZATION_FAILED = 'tokenization_failed',
}

export interface IAviaOrderReference {
    airlines: IAviaOrderReferenceAirline[];
    airports: IAviaOrderReferenceAirport[];
    settlements: IAviaOrderReferenceSettlement[];
    partnerInfo: any; // TODO (frontend, mbobrov) - выяснить используется ли, если да, то специфицировать
}

export interface IAviaOrderReferenceAirline {
    id: number;
    alliance: string | null;
    title: string;
    url: string;
    logoSvg: string;
    color: string;
    sirenaCode: string;
    iataCode: string;
}

export interface IAviaOrderReferenceAirport {
    settlement: number;
    id: number;
    code: string;
    title: string;
    ttype: 'plane';
    phraseFrom: string;
    phraseIn: string;
    phraseTo: string;
    timeZoneCode: string;
    timeZoneOffset: number;
}

export interface IAviaOrderReferenceSettlement {
    id: number;
    countryId: number;
    title: string;
    phraseFrom: string;
    phraseIn: string;
    phraseTo: string;
}
