/* eslint-disable camelcase */

import {StatusCodes} from '../../HotelsBookAPI/constants/statusCodes';

import {
    IOrderAuthorizationResponse,
    TOrderAuthorizationRequestParams,
} from 'server/api/OrdersAPI/types/IOrderAuthorization';

interface ICreateOrderAuthorizationBaseRequestParams {
    /**
     * Телефон или почта
     */
    secret: string;
}

export type TCreateOrderAuthorizationRequestParams =
    ICreateOrderAuthorizationBaseRequestParams &
        TOrderAuthorizationRequestParams;

export interface ICreateOrderAuthorizationApiRequestBody {
    secret: string;
}

export type TCreateOrderAuthorizationApiRequestQuery =
    TOrderAuthorizationRequestParams;

export interface ICreateOrderAuthorizationResponse
    extends IOrderAuthorizationResponse {}

export interface ICreateOrderAuthorizationError {
    statusCode: StatusCodes;
    error: null;
}
