/* eslint-disable camelcase */

import {
    TOrderIdType,
    TYandexOrderIdType,
} from 'server/api/HotelsBookAPI/types/IOrder';

export enum EAuthorizationOrderType {
    HOTEL_EXPEDIA = 'OT_HOTEL_EXPEDIA',
    AVIA_AEROFLOT = 'OT_AVIA_AEROFLOT',
    TRAIN = 'OT_TRAIN',
    BUS = 'OT_BUS',
    TRAIN_ORCH = 'OT_TRAIN_ORCH',
    GENERIC = 'OT_GENERIC',
}

interface IOrderAuthorizationRequestParamsWithId {
    id: TOrderIdType;
    yandex_order_id?: never;
}

interface IOrderAuthorizationRequestParamsWithYandexOrderId {
    id?: never;
    yandex_order_id: TYandexOrderIdType;
}

export type TOrderAuthorizationRequestParams =
    | IOrderAuthorizationRequestParamsWithId
    | IOrderAuthorizationRequestParamsWithYandexOrderId;

export interface IOrderAuthorizationResponse {
    id: TOrderIdType;
    yandexOrderId: TYandexOrderIdType;
    orderType: EAuthorizationOrderType;
}
