export enum EPaymentOutcome {
    PO_SUCCESS = 'PO_SUCCESS',
    PO_FAILURE = 'PO_FAILURE',
}

/**
 * Таблица с причинами
 * https://wiki.yandex-team.ru/trust/payments/rc/
 */
export enum EPaymentFailureResponseCode {
    /**
     * Банк отклонил транзакцию, за подробностями надо обращаться в банк
     */
    AUTHORIZATION_REJECT = 'authorization_reject',
    /**
     * Сработало антифрод правило/алгоритм на стороне процессинга,
     * за выяснением конкретных причин непрохождения платежа необходимо направить запрос в сапорт
     */
    BLACKLISTED = 'blacklisted',
    /**
     * Карта просрочена
     */
    EXPIRED_CARD = 'expired_card',
    /**
     * При оплате Яндекс-кошельками - пользователь не прошёл доп. идентификацию и
     * пытается оплатить выше 15000 руб. или прошёл, но ограничение не снято в нашем терминале
     */
    EXT_ACTION_REQUIRED = 'ext_action_required',
    /**
     * Платеж не авторизован, т.к. пользователь не прошел проверку 3D Secure
     */
    FAIL_3DS = 'fail_3ds',
    /**
     * Ошибка в данных, переданных в платежную систему
     */
    INVALID_PROCESSING_REQUEST = 'invalid_processing_request',
    /**
     * Не были получены яндексовые Cookie
     */
    INVALID_XRF_TOKEN = 'invalid_xrf_token',
    /**
     * Достигнуты лимиты по операциям с картой
     */
    LIMIT_EXCEEDED = 'limit_exceeded',
    /**
     * На карте недостаточно средств
     */
    NOT_ENOUGH_FUNDS = 'not_enough_funds',
    /**
     * Техническая ошибка на стороне платежного шлюза
     */
    PAYMENT_GATEWAY_TECHNICAL_ERROR = 'payment_gateway_technical_error',
    /**
     * Платеж не авторизован, т.к. пользователь не ввел данные за отведенный срок
     */
    PAYMENT_TIMEOUT = 'payment_timeout',
    /**
     * Спец. статус для многоразовых промокодов - пользователь уже воспользовался данным промокодом
     */
    PROMOCODE_ALREADY_USED = 'promocode_already_used',
    /**
     * Карта недействительна (украдена, утеряна и т.п.), транзакцию не нужно повторять!
     */
    RESTRICTED_CARD = 'restricted_card',
    /**
     * Не было получено ответа от платежной системы за отведенный лимит времени
     */
    TIMEOUT_NO_SUCCESS = 'timeout_no_success',
    /**
     * Операция недоступна для данной карты (установлены ограничения пользователем или банком).
     * Например, запрет интернет-транзакций
     */
    TRANSACTION_NOT_PERMITTED = 'transaction_not_permitted',
    /**
     * Не классифицированная ошибка
     */
    UNKNOWN_ERROR = 'unknown_error',
    /**
     * Пользователь отказался от платежа
     */
    USER_CANCELLED = 'user_cancelled',
    /**
     * Неверно заполнены данные, необходимые для выдачи чека
     */
    WRONG_FISCAL_DATA = 'wrong_fiscal_data',
    /**
     * Операция отменена на стороне партнера и далее
     */
    OPERATION_CANCELLED = 'operation_cancelled',
}

interface IGetPaymentTestContextTokenSuccessParams {
    paymentOutcome: EPaymentOutcome.PO_SUCCESS;
}

interface IGetPaymentTestContextTokenFailureParams {
    paymentOutcome: EPaymentOutcome.PO_FAILURE;

    /**
     * Причина неудачи
     */
    paymentFailureResponseCode: EPaymentFailureResponseCode;
    /**
     * Описание может быть условно любым
     */
    paymentFailureResponseDescription: string;
}

export type TGetPaymentTestContextTokenParams =
    | IGetPaymentTestContextTokenSuccessParams
    | IGetPaymentTestContextTokenFailureParams;
