import {EProjectName} from 'constants/common';

import {EOrderApiType} from 'server/api/OrdersAPI/enums/types';
import ITrainsOrderInfoResponse from 'server/api/TrainsBookingApi/types/ITrainsOrderInfoResponse';
import {IOrderResponse} from 'server/api/HotelsBookAPI/types/IOrderResponse';
import {IRequiredOfferParams} from 'types/hotels/offer/IHotelOffer';
import {IBasicGeoRegion} from 'server/api/HotelsBookAPI/types/IBookOfferResponse';
import {IAviaOrderResponse} from 'server/api/OrdersAPI/types/IAviaOrderResponse';
import {IHotelWithMinPrice} from 'types/hotels/hotel/IHotelWithMinPrice';
import {IGenericOrderInfo} from 'server/api/GenericOrderApi/types/common/IGenericOrderInfo';
import IAfishaEventInfo from 'types/trips/IAfishaEventInfo';
import ILinguistics from 'types/common/ILinguistics';
import IIziTravelTourInfo from 'types/trips/IIziTravelTourInfo';
import {EWhiteLabelPointsType} from 'types/common/whiteLabel/EWhiteLabelPointsType';

import IPrice from 'utilities/currency/PriceInterface';

export enum EHappyPageCrossSaleBlock {
    PROMO = 'PROMO',
    HOTEL_CROSS_SALE = 'HOTEL_CROSS_SALE',
    TRANSPORT_CROSS_SALE = 'TRANSPORT_CROSS_SALE',
    COMMON_PROMO_CODE = 'COMMON_PROMO_CODE',
    AFISHA_CROSS_SALE = 'AFISHA_CROSS_SALE',
    IZI_TRAVEL_CROSS_SALE = 'IZI_TRAVEL_CROSS_SALE',
    YANDEX_EDA_PROMO = 'YANDEX_EDA_PROMO',
}

export interface IHappyPageCrossSalePromoBlock {
    blockType: EHappyPageCrossSaleBlock.PROMO;
    order: number;
    payload: null;
    uiPayload: {
        adFoxId: string;
    };
}

export interface IHotelCrossSaleInfo {
    hotelsList: IHotelWithMinPrice[];
    promoBanner: null;
    regionGeoId: number;
    regionLinguistics: IBasicGeoRegion['linguistics'];
    requestParams: IRequiredOfferParams;
    searchUrl: string;
    targetCity: string;
}

export interface IHappyPageCrossSaleHotelsBlock {
    blockType: EHappyPageCrossSaleBlock.HOTEL_CROSS_SALE;
    order: number;
    payload: null;
    uiPayload: IHotelCrossSaleInfo;
}

export interface IHappyPageCrossSaleAfishaBlock {
    blockType: EHappyPageCrossSaleBlock.AFISHA_CROSS_SALE;
    order: number;
    payload: null;
    uiPayload: IHappyPageCrossSaleAfishaPayload;
}

interface IHappyPageCrossSaleAfishaPayload {
    regionLinguistics: ILinguistics;
    regionUrl: string;
    events: IAfishaEventInfo[];
}

export interface IHappyPageCrossSaleIziTravelBlock {
    blockType: EHappyPageCrossSaleBlock.IZI_TRAVEL_CROSS_SALE;
    order: number;
    payload: null;
    uiPayload: IHappyPageCrossSaleIziTravelPayload;
}

interface IHappyPageCrossSaleIziTravelPayload {
    directUrl: string;
    tours: IIziTravelTourInfo[];
}

export type TBlockTypes =
    | EProjectName.AVIA
    | EProjectName.BUSES
    | EProjectName.TRAINS;

export interface IHappyPageCrossSaleTransportBlock {
    type: TBlockTypes;
    from: string;
    to: string;
    departureAt: string;
    adults: number;
    childrenAges: number[];
}

export interface IHappyPageCrossSaleTransportBlocks {
    blockType: EHappyPageCrossSaleBlock.TRANSPORT_CROSS_SALE;
    order: number;
    payload: null;
    uiPayload: {
        regionFromLinguistics?: IBasicGeoRegion['linguistics'] | null;
        regionToLinguistics: IBasicGeoRegion['linguistics'];
        transportBlocks?: IHappyPageCrossSaleTransportBlock[] | null;
    };
}
export interface IHappyPageCrossSaleCommonPromoCodeBlocks {
    blockType: EHappyPageCrossSaleBlock.COMMON_PROMO_CODE;
    order: number;
    payload: null;
    uiPayload: IHappyPageCrossSaleCommonPromoCodeInfo;
}

export interface IHappyPageCrossSaleCommonPromoCodeInfo {
    promoCodeName: string;
    discountAmount: IPrice;
    minOrderPrice: IPrice;
    validTill: string;
    showFrom: string;
    showTill: string;
}

export interface IHappyPageYandexMarketWidgetParams {
    title: string;
    type: 'offers' | 'sku' | 'sku' | 'specifications' | 'reviews';
    fallback: boolean;
    params: {
        clid: number;
        searchModelIds: number[];
        themeId: number;
        buttonLinkType?: string;
        themeRows?: number;
        metrikaCounterId?: number;
    };
}

export interface IYandexEdaPromocodePayload {
    /** Количество промокодов */
    numberOfPromocodes: number;
    /** Цена каждого промокода */
    promocodeCost: IPrice;
    firstSendDate: string;
    /** Может совпадать с firstSendDate, тогда вторую дату не рисуем */
    lastSendDate: string;
}

export interface IWhiteLabelPoints {
    /** Количество баллов */
    amount: number;
    /** Тип баллов */
    pointsType: EWhiteLabelPointsType;
    /** Единица наименования */
    pointsName: string;
}

export interface IYandexEdaPromocodesBlock {
    blockType: EHappyPageCrossSaleBlock.YANDEX_EDA_PROMO;
    order: number;
    uiPayload: IYandexEdaPromocodePayload;
}

export type THappyPageCrossSaleBlock =
    | IHappyPageCrossSaleHotelsBlock
    | IHappyPageCrossSalePromoBlock
    | IHappyPageCrossSaleTransportBlocks
    | IHappyPageCrossSaleCommonPromoCodeBlocks
    | IHappyPageCrossSaleAfishaBlock
    | IHappyPageCrossSaleIziTravelBlock
    | IYandexEdaPromocodesBlock;

interface ICommonResponse {
    crossSale: IHappyPageCrossSale;
}

export interface IHappyPageCrossSale {
    blocks: THappyPageCrossSaleBlock[];
}

export interface IHappyPageTrainApiResponse extends ICommonResponse {
    orderType: EOrderApiType.TRAIN;
    order: ITrainsOrderInfoResponse;
}

export interface IHappyPageHotelApiResponse extends ICommonResponse {
    orderType: EOrderApiType.HOTEL;
    order: IOrderResponse;
}

export interface IHappyPageAviaApiResponse extends ICommonResponse {
    orderType: EOrderApiType.AVIA;
    order: IAviaOrderResponse;
}

export interface IHappyPageBusApiResponse extends ICommonResponse {
    orderType: EOrderApiType.BUS;
    order: IGenericOrderInfo;
}

export type TOrdersGetOrderHappyPageApiResponse =
    | IHappyPageTrainApiResponse
    | IHappyPageHotelApiResponse
    | IHappyPageAviaApiResponse
    | IHappyPageBusApiResponse;
