import {CommonHeaders} from 'server/constants/headers';

import {EApiEntry} from 'types/EApiEntry';
import IGetHotelsSuggestsResponse from './types/IGetHotelsSuggestsResponse';
import IGetAviaSearchHistoryResponse from './types/IGetAviaSearchHistoryResponse';
import IGetHotelsSuggestsRequestParams from './types/IGetHotelsSuggestsRequestParams';
import IGetAviaSearchHistoryRequestParams from './types/IGetAviaSearchHistoryRequestParams';

import {RestApiClient} from 'server/utilities/RestApiClient';
import {IRequestConfig} from 'server/utilities/HttpClient/IHttpClient';

import {IDependencies} from '../../getContainerConfig';

export class PersonalizationApi extends RestApiClient {
    private readonly serviceTicket: string;

    constructor({
        logger,
        requestId,
        getApiHost,
        httpClient,
        sendClickHouseStats,
        getServiceTicket,
        rootSpan,
    }: IDependencies) {
        super({
            baseURL: `${getApiHost(EApiEntry.TRAVEL)}/personalization/v1`,
            logger,
            requestId,
            httpClient,
            sendClickHouseStats,
            rootSpan,
        });

        this.serviceTicket = getServiceTicket('travelAPI');
    }

    getHotelsSuggests(
        params: IGetHotelsSuggestsRequestParams,
    ): Promise<IGetHotelsSuggestsResponse> {
        return this.get<IGetHotelsSuggestsResponse>('/hotels/suggest', {
            params,
        });
    }

    getAviaSearchHistory(
        params: IGetAviaSearchHistoryRequestParams,
    ): Promise<IGetAviaSearchHistoryResponse> {
        return this.get<IGetAviaSearchHistoryResponse>('/avia/history', {
            params,
        });
    }

    protected async interceptRequest(request: IRequestConfig): Promise<void> {
        request.timeout = 25000;
        request.headers = {
            ...request.headers,
            [CommonHeaders.X_YA_SERVICE_TICKET]: this.serviceTicket,
            [CommonHeaders.X_YA_USE_CAMELCASE]: 'true',
        };
    }
}
