import {IRaspParseContextApiParams} from 'server/api/RaspApi/types/IRaspParseContextApiParams';
import {IRaspParseContextApiResponse} from 'server/api/RaspApi/types/IRaspParseContextApiResponse';
import {ITrainCountry} from 'reducers/trains/order/types';
import {EApiEntry} from 'types/EApiEntry';
import {
    IRaspGetTrainOrderSegmentApiParams,
    IRaspGetTrainOrderSegmentApiResponse,
} from 'server/api/RaspApi/types/IRaspGetTrainOrderSegmentApi/IRaspGetTrainOrderSegmentApi';

import {RestApiClient} from 'server/utilities/RestApiClient';
import {IRequestConfig} from 'server/utilities/HttpClient/IHttpClient';

import {IDependencies} from 'server/getContainerConfig';

export class RaspApi extends RestApiClient {
    constructor({
        logger,
        httpClient,
        sendClickHouseStats,
        getApiHost,
        getSrcParams,
        requestId,
        rootSpan,
    }: IDependencies) {
        super({
            baseURL: getApiHost(EApiEntry.RASP),
            logger,
            requestId,
            httpClient,
            sendClickHouseStats,
            rootSpan,
        });

        this.srcParams = getSrcParams(EApiEntry.RASP);
    }

    /**
     * Получение информации о точках отправления и прибытия для жд поиска.
     */
    parseContext({
        language,
        ...params
    }: IRaspParseContextApiParams): Promise<IRaspParseContextApiResponse> {
        return this.get<IRaspParseContextApiResponse>(
            `/${language}/search/parse-context/`,
            {params},
        );
    }

    getTrainOrderSegment({
        language,
        ...params
    }: IRaspGetTrainOrderSegmentApiParams): Promise<IRaspGetTrainOrderSegmentApiResponse> {
        return this.get<IRaspGetTrainOrderSegmentApiResponse>(
            `/${language}/search/train-segment/`,
            {params},
        );
    }

    getCountries(): Promise<ITrainCountry[]> {
        return this.get<{countries: ITrainCountry[]}>('/ru/countries/', {
            params: {national_version: 'ru'},
        }).then(data => data.countries);
    }

    protected interceptRequest(request: IRequestConfig): void | Promise<void> {
        request.params = {
            ...request.params,
            _rid: this.requestId,
        };
    }
}
