import {
    ICompany,
    IStation,
    IThread,
    ITransport,
} from 'projects/trains/lib/segments/types';

export interface ITrainOrderApiSegment {
    arrival: string;
    arrivalEvent: null;
    arrivalEventKey: null;
    company: ICompany;
    departure: string;
    departureEvent: null;
    departureEventKey: null;
    duration: number;
    hasTrainTariffs: null;
    isInterval: boolean;
    isThroughTrain: boolean;
    number: string;
    startDate: string;
    stationFrom: IStation;
    stationTo: IStation;
    stops: string;
    suburbanFacilities: null;
    tariffsKeys?: string[];
    thread: IThread;
    title: string;
    transport: ITransport;

    companies?: ICompany[];
    maxArrival?: string;
    minArrival?: string;
    subSegments?: ITrainOrderApiSegment[];

    oldUfsOrder?: boolean; // проверить, скорее всего перенести в тарифы
}
