import {ESearchErrorTypes} from 'projects/trains/lib/search/constants';

export interface IContextPointCountry {
    code: string;
    title: string;
}

/**
 * Полная информация о пункте отправления/прибытия.
 */
export interface IFilledContextPoint {
    country: IContextPointCountry;
    key: string;
    region: {title: string};
    settlement: {title: string};
    slug: string;
    timezone: string;
    title: string; // Москва
    preposition?: string;
    popularTitle?: string;
    titleAccusative?: string; // Москву
    titleGenitive?: string; // Москвы
    titleWithType?: string;
}

/**
 * С бэка приходит пустая информация о пункте, если передать невалидные данные.
 * Например, в поле slug mosow вместо moscow.
 */
export interface IEmptyContextPoint {
    timezone: null;
    country: null;
    slug: string | null;
    key: string | null;
    title: string | null;
}

export type TContextPointType = IFilledContextPoint | IEmptyContextPoint;

export interface IRaspParseContextApiResponse {
    /**
     * Информация о пункте отправления.
     */
    from: TContextPointType;

    /**
     * Информация о пункте прибытия.
     */
    to: TContextPointType;

    /**
     * Дистанция между пунктами в км.
     *
     * Не приходит для поиска внутри города, например moscow--moscow-yaroslavskaya
     */
    distance?: number;

    /**
     * Ошибки. Например, type: 'point_not_found' - пункт отправления/прибытия не найден.
     */
    errors: {
        type: ESearchErrorTypes;
    }[];
}
