import {IRaspParseContextApiParams} from 'server/api/RaspApi/types/IRaspParseContextApiParams';
import {IRaspParseContextApiResponse} from 'server/api/RaspApi/types/IRaspParseContextApiResponse';
import {EApiEntry} from 'types/EApiEntry';

import {IRequestConfig} from 'server/utilities/HttpClient/IHttpClient';
import {RestApiClient} from 'server/utilities/RestApiClient';

import {IDependencies} from 'server/getContainerConfig';

export class RaspCacheApi extends RestApiClient {
    constructor({
        logger,
        httpClient,
        sendClickHouseStats,
        getApiHost,
        getSrcParams,
        requestId,
        rootSpan,
    }: IDependencies) {
        super({
            baseURL: getApiHost(EApiEntry.RASP_CACHE),
            logger,
            requestId,
            httpClient,
            sendClickHouseStats,
            rootSpan,
        });

        this.srcParams = getSrcParams(EApiEntry.RASP_CACHE);
    }

    parseContext({
        language,
        ...params
    }: IRaspParseContextApiParams): Promise<IRaspParseContextApiResponse> {
        return this.get<IRaspParseContextApiResponse>(
            `/${language}/search/parse-context/`,
            {params},
        );
    }

    protected interceptRequest(request: IRequestConfig): void | Promise<void> {
        request.params = {
            ...request.params,
            _rid: this.requestId,
        };
    }
}
