import {IRaspGetSuggestsApiParams} from 'server/api/RaspSuggestsApi/types/IRaspGetSuggestsApiParams';
import {IRaspGetSuggestsApiResponse} from 'server/api/RaspSuggestsApi/types/IRaspGetSuggestsApiResponse';
import {EApiEntry} from 'types/EApiEntry';

import {RestApiClient} from 'server/utilities/RestApiClient';

import {IDependencies} from 'server/getContainerConfig';

export class RaspSuggestsApi extends RestApiClient {
    constructor({
        logger,
        httpClient,
        sendClickHouseStats,
        getApiHost,
        getSrcParams,
        requestId,
        rootSpan,
    }: IDependencies) {
        super({
            baseURL: getApiHost(EApiEntry.RASP_SUGGESTS),
            logger,
            requestId,
            httpClient,
            sendClickHouseStats,
            rootSpan,
        });

        this.srcParams = getSrcParams(EApiEntry.RASP_SUGGESTS);
    }

    getSuggests(
        params: IRaspGetSuggestsApiParams,
    ): Promise<IRaspGetSuggestsApiResponse> {
        return this.get<IRaspGetSuggestsApiResponse>(`/by_t_type`, {params});
    }
}
