import {EApiEntry} from 'types/EApiEntry';
import {IReviewsGetTrainsReviewsApiResponse} from 'server/api/ReviewsApi/types/IReviewsGetTrainsReviewsApiResponse';

import {RestApiClient} from 'server/utilities/RestApiClient';

import {IDependencies} from '../../getContainerConfig';

export class ReviewsApi extends RestApiClient {
    constructor({
        logger,
        requestId,
        getApiHost,
        httpClient,
        sendClickHouseStats,
        rootSpan,
    }: IDependencies) {
        super({
            baseURL: getApiHost(EApiEntry.REVIEWS),
            logger,
            requestId,
            httpClient,
            sendClickHouseStats,
            rootSpan,
        });
    }

    getTrainsReviews(): Promise<IReviewsGetTrainsReviewsApiResponse> {
        return this.get<IReviewsGetTrainsReviewsApiResponse>(
            '/trains/data.json',
        );
    }
}
